package io.github.vigoo.zioaws.memorydb.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateSnapshotResponse(
    snapshot: Option[io.github.vigoo.zioaws.memorydb.model.Snapshot] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.CreateSnapshotResponse = {
    import CreateSnapshotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.CreateSnapshotResponse
      .builder()
      .optionallyWith(snapshot.map(value => value.buildAwsValue()))(_.snapshot)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.CreateSnapshotResponse.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.CreateSnapshotResponse
      .wrap(buildAwsValue())
}
object CreateSnapshotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.CreateSnapshotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.memorydb.model.CreateSnapshotResponse =
      io.github.vigoo.zioaws.memorydb.model
        .CreateSnapshotResponse(snapshotValue.map(value => value.editable))
    def snapshotValue
        : Option[io.github.vigoo.zioaws.memorydb.model.Snapshot.ReadOnly]
    def snapshot: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.Snapshot.ReadOnly
    ] = AwsError.unwrapOptionField("snapshot", snapshotValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.CreateSnapshotResponse
  ) extends io.github.vigoo.zioaws.memorydb.model.CreateSnapshotResponse.ReadOnly {
    override def snapshotValue
        : Option[io.github.vigoo.zioaws.memorydb.model.Snapshot.ReadOnly] =
      scala
        .Option(impl.snapshot())
        .map(value =>
          io.github.vigoo.zioaws.memorydb.model.Snapshot.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.CreateSnapshotResponse
  ): io.github.vigoo.zioaws.memorydb.model.CreateSnapshotResponse.ReadOnly =
    new Wrapper(impl)
}
