package io.github.vigoo.zioaws.memorydb.model
import io.github.vigoo.zioaws.memorydb.model.primitives.{KmsKeyId, TargetBucket}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CopySnapshotRequest(
    sourceSnapshotName: String,
    targetSnapshotName: String,
    targetBucket: Option[TargetBucket] = None,
    kmsKeyId: Option[KmsKeyId] = None,
    tags: Option[Iterable[io.github.vigoo.zioaws.memorydb.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.CopySnapshotRequest = {
    import CopySnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.CopySnapshotRequest
      .builder()
      .sourceSnapshotName(sourceSnapshotName: java.lang.String)
      .targetSnapshotName(targetSnapshotName: java.lang.String)
      .optionallyWith(targetBucket.map(value => value: java.lang.String))(
        _.targetBucket
      )
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.CopySnapshotRequest.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.CopySnapshotRequest
      .wrap(buildAwsValue())
}
object CopySnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.CopySnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.memorydb.model.CopySnapshotRequest =
      io.github.vigoo.zioaws.memorydb.model.CopySnapshotRequest(
        sourceSnapshotNameValue,
        targetSnapshotNameValue,
        targetBucketValue.map(value => value),
        kmsKeyIdValue.map(value => value),
        tagsValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def sourceSnapshotNameValue: String
    def targetSnapshotNameValue: String
    def targetBucketValue: Option[TargetBucket]
    def kmsKeyIdValue: Option[KmsKeyId]
    def tagsValue
        : Option[List[io.github.vigoo.zioaws.memorydb.model.Tag.ReadOnly]]
    def sourceSnapshotName: ZIO[Any, Nothing, String] =
      ZIO.succeed(sourceSnapshotNameValue)
    def targetSnapshotName: ZIO[Any, Nothing, String] =
      ZIO.succeed(targetSnapshotNameValue)
    def targetBucket: ZIO[Any, AwsError, TargetBucket] =
      AwsError.unwrapOptionField("targetBucket", targetBucketValue)
    def kmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyIdValue)
    def tags: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.memorydb.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tagsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.CopySnapshotRequest
  ) extends io.github.vigoo.zioaws.memorydb.model.CopySnapshotRequest.ReadOnly {
    override def sourceSnapshotNameValue: String =
      impl.sourceSnapshotName(): String
    override def targetSnapshotNameValue: String =
      impl.targetSnapshotName(): String
    override def targetBucketValue: Option[TargetBucket] =
      scala.Option(impl.targetBucket()).map(value => value: TargetBucket)
    override def kmsKeyIdValue: Option[KmsKeyId] =
      scala.Option(impl.kmsKeyId()).map(value => value: KmsKeyId)
    override def tagsValue
        : Option[List[io.github.vigoo.zioaws.memorydb.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.memorydb.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.CopySnapshotRequest
  ): io.github.vigoo.zioaws.memorydb.model.CopySnapshotRequest.ReadOnly =
    new Wrapper(impl)
}
