package io.github.vigoo.zioaws.memorydb.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ClusterPendingUpdates(
    resharding: Option[io.github.vigoo.zioaws.memorydb.model.ReshardingStatus] =
      None,
    acLs: Option[io.github.vigoo.zioaws.memorydb.model.ACLsUpdateStatus] = None,
    serviceUpdates: Option[Iterable[
      io.github.vigoo.zioaws.memorydb.model.PendingModifiedServiceUpdate
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.ClusterPendingUpdates = {
    import ClusterPendingUpdates.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.ClusterPendingUpdates
      .builder()
      .optionallyWith(resharding.map(value => value.buildAwsValue()))(
        _.resharding
      )
      .optionallyWith(acLs.map(value => value.buildAwsValue()))(_.acLs)
      .optionallyWith(
        serviceUpdates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.serviceUpdates)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.ClusterPendingUpdates.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.ClusterPendingUpdates
      .wrap(buildAwsValue())
}
object ClusterPendingUpdates {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.ClusterPendingUpdates
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.memorydb.model.ClusterPendingUpdates =
      io.github.vigoo.zioaws.memorydb.model.ClusterPendingUpdates(
        reshardingValue.map(value => value.editable),
        acLsValue.map(value => value.editable),
        serviceUpdatesValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def reshardingValue: Option[
      io.github.vigoo.zioaws.memorydb.model.ReshardingStatus.ReadOnly
    ]
    def acLsValue: Option[
      io.github.vigoo.zioaws.memorydb.model.ACLsUpdateStatus.ReadOnly
    ]
    def serviceUpdatesValue: Option[List[
      io.github.vigoo.zioaws.memorydb.model.PendingModifiedServiceUpdate.ReadOnly
    ]]
    def resharding: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.ReshardingStatus.ReadOnly
    ] = AwsError.unwrapOptionField("resharding", reshardingValue)
    def acLs: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.ACLsUpdateStatus.ReadOnly
    ] = AwsError.unwrapOptionField("acLs", acLsValue)
    def serviceUpdates: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.memorydb.model.PendingModifiedServiceUpdate.ReadOnly
    ]] = AwsError.unwrapOptionField("serviceUpdates", serviceUpdatesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.ClusterPendingUpdates
  ) extends io.github.vigoo.zioaws.memorydb.model.ClusterPendingUpdates.ReadOnly {
    override def reshardingValue: Option[
      io.github.vigoo.zioaws.memorydb.model.ReshardingStatus.ReadOnly
    ] = scala
      .Option(impl.resharding())
      .map(value =>
        io.github.vigoo.zioaws.memorydb.model.ReshardingStatus.wrap(value)
      )
    override def acLsValue: Option[
      io.github.vigoo.zioaws.memorydb.model.ACLsUpdateStatus.ReadOnly
    ] = scala
      .Option(impl.acLs())
      .map(value =>
        io.github.vigoo.zioaws.memorydb.model.ACLsUpdateStatus.wrap(value)
      )
    override def serviceUpdatesValue: Option[List[
      io.github.vigoo.zioaws.memorydb.model.PendingModifiedServiceUpdate.ReadOnly
    ]] = scala
      .Option(impl.serviceUpdates())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.memorydb.model.PendingModifiedServiceUpdate
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.ClusterPendingUpdates
  ): io.github.vigoo.zioaws.memorydb.model.ClusterPendingUpdates.ReadOnly =
    new Wrapper(impl)
}
