package io.github.vigoo.zioaws.memorydb.model
import io.github.vigoo.zioaws.memorydb.model.primitives.{
  ACLName,
  BooleanOptional,
  IntegerOptional
}
import java.lang.Integer
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Cluster(
    name: Option[String] = None,
    description: Option[String] = None,
    status: Option[String] = None,
    pendingUpdates: Option[
      io.github.vigoo.zioaws.memorydb.model.ClusterPendingUpdates
    ] = None,
    numberOfShards: Option[IntegerOptional] = None,
    shards: Option[Iterable[io.github.vigoo.zioaws.memorydb.model.Shard]] =
      None,
    availabilityMode: Option[io.github.vigoo.zioaws.memorydb.model.AZStatus] =
      None,
    clusterEndpoint: Option[io.github.vigoo.zioaws.memorydb.model.Endpoint] =
      None,
    nodeType: Option[String] = None,
    engineVersion: Option[String] = None,
    enginePatchVersion: Option[String] = None,
    parameterGroupName: Option[String] = None,
    parameterGroupStatus: Option[String] = None,
    securityGroups: Option[
      Iterable[io.github.vigoo.zioaws.memorydb.model.SecurityGroupMembership]
    ] = None,
    subnetGroupName: Option[String] = None,
    tlsEnabled: Option[BooleanOptional] = None,
    kmsKeyId: Option[String] = None,
    arn: Option[String] = None,
    snsTopicArn: Option[String] = None,
    snsTopicStatus: Option[String] = None,
    snapshotRetentionLimit: Option[IntegerOptional] = None,
    maintenanceWindow: Option[String] = None,
    snapshotWindow: Option[String] = None,
    aclName: Option[ACLName] = None,
    autoMinorVersionUpgrade: Option[BooleanOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.Cluster = {
    import Cluster.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.Cluster
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(pendingUpdates.map(value => value.buildAwsValue()))(
        _.pendingUpdates
      )
      .optionallyWith(numberOfShards.map(value => value: Integer))(
        _.numberOfShards
      )
      .optionallyWith(
        shards.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.shards)
      .optionallyWith(availabilityMode.map(value => value.unwrap))(
        _.availabilityMode
      )
      .optionallyWith(clusterEndpoint.map(value => value.buildAwsValue()))(
        _.clusterEndpoint
      )
      .optionallyWith(nodeType.map(value => value: java.lang.String))(
        _.nodeType
      )
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(enginePatchVersion.map(value => value: java.lang.String))(
        _.enginePatchVersion
      )
      .optionallyWith(parameterGroupName.map(value => value: java.lang.String))(
        _.parameterGroupName
      )
      .optionallyWith(
        parameterGroupStatus.map(value => value: java.lang.String)
      )(_.parameterGroupStatus)
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.securityGroups)
      .optionallyWith(subnetGroupName.map(value => value: java.lang.String))(
        _.subnetGroupName
      )
      .optionallyWith(tlsEnabled.map(value => value: java.lang.Boolean))(
        _.tlsEnabled
      )
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(snsTopicArn.map(value => value: java.lang.String))(
        _.snsTopicArn
      )
      .optionallyWith(snsTopicStatus.map(value => value: java.lang.String))(
        _.snsTopicStatus
      )
      .optionallyWith(snapshotRetentionLimit.map(value => value: Integer))(
        _.snapshotRetentionLimit
      )
      .optionallyWith(maintenanceWindow.map(value => value: java.lang.String))(
        _.maintenanceWindow
      )
      .optionallyWith(snapshotWindow.map(value => value: java.lang.String))(
        _.snapshotWindow
      )
      .optionallyWith(aclName.map(value => value: java.lang.String))(_.aclName)
      .optionallyWith(
        autoMinorVersionUpgrade.map(value => value: java.lang.Boolean)
      )(_.autoMinorVersionUpgrade)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.memorydb.model.Cluster.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.Cluster.wrap(buildAwsValue())
}
object Cluster {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.memorydb.model.Cluster] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.memorydb.model.Cluster =
      io.github.vigoo.zioaws.memorydb.model.Cluster(
        nameValue.map(value => value),
        descriptionValue.map(value => value),
        statusValue.map(value => value),
        pendingUpdatesValue.map(value => value.editable),
        numberOfShardsValue.map(value => value),
        shardsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        availabilityModeValue.map(value => value),
        clusterEndpointValue.map(value => value.editable),
        nodeTypeValue.map(value => value),
        engineVersionValue.map(value => value),
        enginePatchVersionValue.map(value => value),
        parameterGroupNameValue.map(value => value),
        parameterGroupStatusValue.map(value => value),
        securityGroupsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        subnetGroupNameValue.map(value => value),
        tlsEnabledValue.map(value => value),
        kmsKeyIdValue.map(value => value),
        arnValue.map(value => value),
        snsTopicArnValue.map(value => value),
        snsTopicStatusValue.map(value => value),
        snapshotRetentionLimitValue.map(value => value),
        maintenanceWindowValue.map(value => value),
        snapshotWindowValue.map(value => value),
        aclNameValue.map(value => value),
        autoMinorVersionUpgradeValue.map(value => value)
      )
    def nameValue: Option[String]
    def descriptionValue: Option[String]
    def statusValue: Option[String]
    def pendingUpdatesValue: Option[
      io.github.vigoo.zioaws.memorydb.model.ClusterPendingUpdates.ReadOnly
    ]
    def numberOfShardsValue: Option[IntegerOptional]
    def shardsValue
        : Option[List[io.github.vigoo.zioaws.memorydb.model.Shard.ReadOnly]]
    def availabilityModeValue
        : Option[io.github.vigoo.zioaws.memorydb.model.AZStatus]
    def clusterEndpointValue
        : Option[io.github.vigoo.zioaws.memorydb.model.Endpoint.ReadOnly]
    def nodeTypeValue: Option[String]
    def engineVersionValue: Option[String]
    def enginePatchVersionValue: Option[String]
    def parameterGroupNameValue: Option[String]
    def parameterGroupStatusValue: Option[String]
    def securityGroupsValue: Option[List[
      io.github.vigoo.zioaws.memorydb.model.SecurityGroupMembership.ReadOnly
    ]]
    def subnetGroupNameValue: Option[String]
    def tlsEnabledValue: Option[BooleanOptional]
    def kmsKeyIdValue: Option[String]
    def arnValue: Option[String]
    def snsTopicArnValue: Option[String]
    def snsTopicStatusValue: Option[String]
    def snapshotRetentionLimitValue: Option[IntegerOptional]
    def maintenanceWindowValue: Option[String]
    def snapshotWindowValue: Option[String]
    def aclNameValue: Option[ACLName]
    def autoMinorVersionUpgradeValue: Option[BooleanOptional]
    def name: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", nameValue)
    def description: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", descriptionValue)
    def status: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", statusValue)
    def pendingUpdates: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.ClusterPendingUpdates.ReadOnly
    ] = AwsError.unwrapOptionField("pendingUpdates", pendingUpdatesValue)
    def numberOfShards: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("numberOfShards", numberOfShardsValue)
    def shards: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.memorydb.model.Shard.ReadOnly
    ]] = AwsError.unwrapOptionField("shards", shardsValue)
    def availabilityMode
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.memorydb.model.AZStatus] =
      AwsError.unwrapOptionField("availabilityMode", availabilityModeValue)
    def clusterEndpoint: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.Endpoint.ReadOnly
    ] = AwsError.unwrapOptionField("clusterEndpoint", clusterEndpointValue)
    def nodeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodeType", nodeTypeValue)
    def engineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersionValue)
    def enginePatchVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("enginePatchVersion", enginePatchVersionValue)
    def parameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterGroupName", parameterGroupNameValue)
    def parameterGroupStatus: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("parameterGroupStatus", parameterGroupStatusValue)
    def securityGroups: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.memorydb.model.SecurityGroupMembership.ReadOnly
    ]] = AwsError.unwrapOptionField("securityGroups", securityGroupsValue)
    def subnetGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subnetGroupName", subnetGroupNameValue)
    def tlsEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("tlsEnabled", tlsEnabledValue)
    def kmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyIdValue)
    def arn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arnValue)
    def snsTopicArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snsTopicArn", snsTopicArnValue)
    def snsTopicStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snsTopicStatus", snsTopicStatusValue)
    def snapshotRetentionLimit: ZIO[Any, AwsError, IntegerOptional] = AwsError
      .unwrapOptionField("snapshotRetentionLimit", snapshotRetentionLimitValue)
    def maintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("maintenanceWindow", maintenanceWindowValue)
    def snapshotWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotWindow", snapshotWindowValue)
    def aclName: ZIO[Any, AwsError, ACLName] =
      AwsError.unwrapOptionField("aclName", aclNameValue)
    def autoMinorVersionUpgrade: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "autoMinorVersionUpgrade",
        autoMinorVersionUpgradeValue
      )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.Cluster
  ) extends io.github.vigoo.zioaws.memorydb.model.Cluster.ReadOnly {
    override def nameValue: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override def descriptionValue: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override def statusValue: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override def pendingUpdatesValue: Option[
      io.github.vigoo.zioaws.memorydb.model.ClusterPendingUpdates.ReadOnly
    ] = scala
      .Option(impl.pendingUpdates())
      .map(value =>
        io.github.vigoo.zioaws.memorydb.model.ClusterPendingUpdates.wrap(value)
      )
    override def numberOfShardsValue: Option[IntegerOptional] =
      scala.Option(impl.numberOfShards()).map(value => value: IntegerOptional)
    override def shardsValue
        : Option[List[io.github.vigoo.zioaws.memorydb.model.Shard.ReadOnly]] =
      scala
        .Option(impl.shards())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.memorydb.model.Shard.wrap(item)
          }.toList
        )
    override def availabilityModeValue
        : Option[io.github.vigoo.zioaws.memorydb.model.AZStatus] = scala
      .Option(impl.availabilityMode())
      .map(value => io.github.vigoo.zioaws.memorydb.model.AZStatus.wrap(value))
    override def clusterEndpointValue
        : Option[io.github.vigoo.zioaws.memorydb.model.Endpoint.ReadOnly] =
      scala
        .Option(impl.clusterEndpoint())
        .map(value =>
          io.github.vigoo.zioaws.memorydb.model.Endpoint.wrap(value)
        )
    override def nodeTypeValue: Option[String] =
      scala.Option(impl.nodeType()).map(value => value: String)
    override def engineVersionValue: Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override def enginePatchVersionValue: Option[String] =
      scala.Option(impl.enginePatchVersion()).map(value => value: String)
    override def parameterGroupNameValue: Option[String] =
      scala.Option(impl.parameterGroupName()).map(value => value: String)
    override def parameterGroupStatusValue: Option[String] =
      scala.Option(impl.parameterGroupStatus()).map(value => value: String)
    override def securityGroupsValue: Option[List[
      io.github.vigoo.zioaws.memorydb.model.SecurityGroupMembership.ReadOnly
    ]] = scala
      .Option(impl.securityGroups())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.memorydb.model.SecurityGroupMembership
            .wrap(item)
        }.toList
      )
    override def subnetGroupNameValue: Option[String] =
      scala.Option(impl.subnetGroupName()).map(value => value: String)
    override def tlsEnabledValue: Option[BooleanOptional] =
      scala.Option(impl.tlsEnabled()).map(value => value: BooleanOptional)
    override def kmsKeyIdValue: Option[String] =
      scala.Option(impl.kmsKeyId()).map(value => value: String)
    override def arnValue: Option[String] =
      scala.Option(impl.arn()).map(value => value: String)
    override def snsTopicArnValue: Option[String] =
      scala.Option(impl.snsTopicArn()).map(value => value: String)
    override def snsTopicStatusValue: Option[String] =
      scala.Option(impl.snsTopicStatus()).map(value => value: String)
    override def snapshotRetentionLimitValue: Option[IntegerOptional] = scala
      .Option(impl.snapshotRetentionLimit())
      .map(value => value: IntegerOptional)
    override def maintenanceWindowValue: Option[String] =
      scala.Option(impl.maintenanceWindow()).map(value => value: String)
    override def snapshotWindowValue: Option[String] =
      scala.Option(impl.snapshotWindow()).map(value => value: String)
    override def aclNameValue: Option[ACLName] =
      scala.Option(impl.aclName()).map(value => value: ACLName)
    override def autoMinorVersionUpgradeValue: Option[BooleanOptional] = scala
      .Option(impl.autoMinorVersionUpgrade())
      .map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.Cluster
  ): io.github.vigoo.zioaws.memorydb.model.Cluster.ReadOnly = new Wrapper(impl)
}
