package io.github.vigoo.zioaws.memorydb.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class BatchUpdateClusterRequest(
    clusterNames: Iterable[String],
    serviceUpdate: Option[
      io.github.vigoo.zioaws.memorydb.model.ServiceUpdateRequest
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.BatchUpdateClusterRequest = {
    import BatchUpdateClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.BatchUpdateClusterRequest
      .builder()
      .clusterNames(clusterNames.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .optionallyWith(serviceUpdate.map(value => value.buildAwsValue()))(
        _.serviceUpdate
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.BatchUpdateClusterRequest.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.BatchUpdateClusterRequest
      .wrap(buildAwsValue())
}
object BatchUpdateClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.BatchUpdateClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.memorydb.model.BatchUpdateClusterRequest =
      io.github.vigoo.zioaws.memorydb.model.BatchUpdateClusterRequest(
        clusterNamesValue,
        serviceUpdateValue.map(value => value.editable)
      )
    def clusterNamesValue: List[String]
    def serviceUpdateValue: Option[
      io.github.vigoo.zioaws.memorydb.model.ServiceUpdateRequest.ReadOnly
    ]
    def clusterNames: ZIO[Any, Nothing, List[String]] =
      ZIO.succeed(clusterNamesValue)
    def serviceUpdate: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.ServiceUpdateRequest.ReadOnly
    ] = AwsError.unwrapOptionField("serviceUpdate", serviceUpdateValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.BatchUpdateClusterRequest
  ) extends io.github.vigoo.zioaws.memorydb.model.BatchUpdateClusterRequest.ReadOnly {
    override def clusterNamesValue: List[String] = impl
      .clusterNames()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override def serviceUpdateValue: Option[
      io.github.vigoo.zioaws.memorydb.model.ServiceUpdateRequest.ReadOnly
    ] = scala
      .Option(impl.serviceUpdate())
      .map(value =>
        io.github.vigoo.zioaws.memorydb.model.ServiceUpdateRequest.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.BatchUpdateClusterRequest
  ): io.github.vigoo.zioaws.memorydb.model.BatchUpdateClusterRequest.ReadOnly =
    new Wrapper(impl)
}
