package io.github.vigoo.zioaws.memorydb.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AvailabilityZone(name: Option[String] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.AvailabilityZone = {
    import AvailabilityZone.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.AvailabilityZone
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.AvailabilityZone.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.AvailabilityZone.wrap(buildAwsValue())
}
object AvailabilityZone {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.AvailabilityZone
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.memorydb.model.AvailabilityZone =
      io.github.vigoo.zioaws.memorydb.model
        .AvailabilityZone(nameValue.map(value => value))
    def nameValue: Option[String]
    def name: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", nameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.AvailabilityZone
  ) extends io.github.vigoo.zioaws.memorydb.model.AvailabilityZone.ReadOnly {
    override def nameValue: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.AvailabilityZone
  ): io.github.vigoo.zioaws.memorydb.model.AvailabilityZone.ReadOnly =
    new Wrapper(impl)
}
