package io.github.vigoo.zioaws.memorydb.model
import io.github.vigoo.zioaws.memorydb.model.primitives.ACLName
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ACLsUpdateStatus(aclToApply: Option[ACLName] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.ACLsUpdateStatus = {
    import ACLsUpdateStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.ACLsUpdateStatus
      .builder()
      .optionallyWith(aclToApply.map(value => value: java.lang.String))(
        _.aclToApply
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.ACLsUpdateStatus.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.ACLsUpdateStatus.wrap(buildAwsValue())
}
object ACLsUpdateStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.ACLsUpdateStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.memorydb.model.ACLsUpdateStatus =
      io.github.vigoo.zioaws.memorydb.model
        .ACLsUpdateStatus(aclToApplyValue.map(value => value))
    def aclToApplyValue: Option[ACLName]
    def aclToApply: ZIO[Any, AwsError, ACLName] =
      AwsError.unwrapOptionField("aclToApply", aclToApplyValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.ACLsUpdateStatus
  ) extends io.github.vigoo.zioaws.memorydb.model.ACLsUpdateStatus.ReadOnly {
    override def aclToApplyValue: Option[ACLName] =
      scala.Option(impl.aclToApply()).map(value => value: ACLName)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.ACLsUpdateStatus
  ): io.github.vigoo.zioaws.memorydb.model.ACLsUpdateStatus.ReadOnly =
    new Wrapper(impl)
}
