package io.github.vigoo.zioaws.memorydb.model
import io.github.vigoo.zioaws.memorydb.model.primitives.IntegerOptional
import java.lang.Integer
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeParametersRequest(
    parameterGroupName: String,
    maxResults: Option[IntegerOptional] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DescribeParametersRequest = {
    import DescribeParametersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DescribeParametersRequest
      .builder()
      .parameterGroupName(parameterGroupName: java.lang.String)
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.DescribeParametersRequest.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.DescribeParametersRequest
      .wrap(buildAwsValue())
}
object DescribeParametersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DescribeParametersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.memorydb.model.DescribeParametersRequest =
      io.github.vigoo.zioaws.memorydb.model.DescribeParametersRequest(
        parameterGroupNameValue,
        maxResultsValue.map(value => value),
        nextTokenValue.map(value => value)
      )
    def parameterGroupNameValue: String
    def maxResultsValue: Option[IntegerOptional]
    def nextTokenValue: Option[String]
    def parameterGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(parameterGroupNameValue)
    def maxResults: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxResults", maxResultsValue)
    def nextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeParametersRequest
  ) extends io.github.vigoo.zioaws.memorydb.model.DescribeParametersRequest.ReadOnly {
    override def parameterGroupNameValue: String =
      impl.parameterGroupName(): String
    override def maxResultsValue: Option[IntegerOptional] =
      scala.Option(impl.maxResults()).map(value => value: IntegerOptional)
    override def nextTokenValue: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeParametersRequest
  ): io.github.vigoo.zioaws.memorydb.model.DescribeParametersRequest.ReadOnly =
    new Wrapper(impl)
}
