package io.github.vigoo.zioaws.memorydb.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateSnapshotRequest(
    clusterName: String,
    snapshotName: String,
    kmsKeyId: Option[String] = None,
    tags: Option[Iterable[io.github.vigoo.zioaws.memorydb.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.CreateSnapshotRequest = {
    import CreateSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.CreateSnapshotRequest
      .builder()
      .clusterName(clusterName: java.lang.String)
      .snapshotName(snapshotName: java.lang.String)
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.CreateSnapshotRequest.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.CreateSnapshotRequest
      .wrap(buildAwsValue())
}
object CreateSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.CreateSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.memorydb.model.CreateSnapshotRequest =
      io.github.vigoo.zioaws.memorydb.model.CreateSnapshotRequest(
        clusterNameValue,
        snapshotNameValue,
        kmsKeyIdValue.map(value => value),
        tagsValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def clusterNameValue: String
    def snapshotNameValue: String
    def kmsKeyIdValue: Option[String]
    def tagsValue
        : Option[List[io.github.vigoo.zioaws.memorydb.model.Tag.ReadOnly]]
    def clusterName: ZIO[Any, Nothing, String] = ZIO.succeed(clusterNameValue)
    def snapshotName: ZIO[Any, Nothing, String] = ZIO.succeed(snapshotNameValue)
    def kmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyIdValue)
    def tags: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.memorydb.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tagsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.CreateSnapshotRequest
  ) extends io.github.vigoo.zioaws.memorydb.model.CreateSnapshotRequest.ReadOnly {
    override def clusterNameValue: String = impl.clusterName(): String
    override def snapshotNameValue: String = impl.snapshotName(): String
    override def kmsKeyIdValue: Option[String] =
      scala.Option(impl.kmsKeyId()).map(value => value: String)
    override def tagsValue
        : Option[List[io.github.vigoo.zioaws.memorydb.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.memorydb.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.CreateSnapshotRequest
  ): io.github.vigoo.zioaws.memorydb.model.CreateSnapshotRequest.ReadOnly =
    new Wrapper(impl)
}
