package io.github.vigoo.zioaws.memorydb.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PendingModifiedServiceUpdate(
    serviceUpdateName: Option[String] = None,
    status: Option[io.github.vigoo.zioaws.memorydb.model.ServiceUpdateStatus] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.PendingModifiedServiceUpdate = {
    import PendingModifiedServiceUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.PendingModifiedServiceUpdate
      .builder()
      .optionallyWith(serviceUpdateName.map(value => value: java.lang.String))(
        _.serviceUpdateName
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.PendingModifiedServiceUpdate.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.PendingModifiedServiceUpdate
      .wrap(buildAwsValue())
}
object PendingModifiedServiceUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.PendingModifiedServiceUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.memorydb.model.PendingModifiedServiceUpdate =
      io.github.vigoo.zioaws.memorydb.model.PendingModifiedServiceUpdate(
        serviceUpdateNameValue.map(value => value),
        statusValue.map(value => value)
      )
    def serviceUpdateNameValue: Option[String]
    def statusValue
        : Option[io.github.vigoo.zioaws.memorydb.model.ServiceUpdateStatus]
    def serviceUpdateName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceUpdateName", serviceUpdateNameValue)
    def status: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.ServiceUpdateStatus
    ] = AwsError.unwrapOptionField("status", statusValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.PendingModifiedServiceUpdate
  ) extends io.github.vigoo.zioaws.memorydb.model.PendingModifiedServiceUpdate.ReadOnly {
    override def serviceUpdateNameValue: Option[String] =
      scala.Option(impl.serviceUpdateName()).map(value => value: String)
    override def statusValue
        : Option[io.github.vigoo.zioaws.memorydb.model.ServiceUpdateStatus] =
      scala
        .Option(impl.status())
        .map(value =>
          io.github.vigoo.zioaws.memorydb.model.ServiceUpdateStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.PendingModifiedServiceUpdate
  ): io.github.vigoo.zioaws.memorydb.model.PendingModifiedServiceUpdate.ReadOnly =
    new Wrapper(impl)
}
