package io.github.vigoo.zioaws.lexruntime.model
import java.lang.Integer
import io.github.vigoo.zioaws.lexruntime.model.primitives.{
  ActiveContextTurnsToLive,
  ActiveContextTimeToLiveInSeconds
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ActiveContextTimeToLive(
    timeToLiveInSeconds: Option[ActiveContextTimeToLiveInSeconds] = None,
    turnsToLive: Option[ActiveContextTurnsToLive] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntime.model.ActiveContextTimeToLive = {
    import ActiveContextTimeToLive.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntime.model.ActiveContextTimeToLive
      .builder()
      .optionallyWith(timeToLiveInSeconds.map(value => value: Integer))(
        _.timeToLiveInSeconds
      )
      .optionallyWith(turnsToLive.map(value => value: Integer))(_.turnsToLive)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lexruntime.model.ActiveContextTimeToLive.ReadOnly =
    io.github.vigoo.zioaws.lexruntime.model.ActiveContextTimeToLive
      .wrap(buildAwsValue())
}
object ActiveContextTimeToLive {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntime.model.ActiveContextTimeToLive
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lexruntime.model.ActiveContextTimeToLive =
      io.github.vigoo.zioaws.lexruntime.model.ActiveContextTimeToLive(
        timeToLiveInSecondsValue.map(value => value),
        turnsToLiveValue.map(value => value)
      )
    def timeToLiveInSecondsValue: Option[ActiveContextTimeToLiveInSeconds]
    def turnsToLiveValue: Option[ActiveContextTurnsToLive]
    def timeToLiveInSeconds
        : ZIO[Any, AwsError, ActiveContextTimeToLiveInSeconds] = AwsError
      .unwrapOptionField("timeToLiveInSeconds", timeToLiveInSecondsValue)
    def turnsToLive: ZIO[Any, AwsError, ActiveContextTurnsToLive] =
      AwsError.unwrapOptionField("turnsToLive", turnsToLiveValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lexruntime.model.ActiveContextTimeToLive
  ) extends io.github.vigoo.zioaws.lexruntime.model.ActiveContextTimeToLive.ReadOnly {
    override def timeToLiveInSecondsValue
        : Option[ActiveContextTimeToLiveInSeconds] = scala
      .Option(impl.timeToLiveInSeconds())
      .map(value => value: ActiveContextTimeToLiveInSeconds)
    override def turnsToLiveValue: Option[ActiveContextTurnsToLive] = scala
      .Option(impl.turnsToLive())
      .map(value => value: ActiveContextTurnsToLive)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntime.model.ActiveContextTimeToLive
  ): io.github.vigoo.zioaws.lexruntime.model.ActiveContextTimeToLive.ReadOnly =
    new Wrapper(impl)
}
