package io.github.vigoo.zioaws.lexruntime.model
import io.github.vigoo.zioaws.lexruntime.model.primitives.{
  ButtonValueStringWithLength,
  ButtonTextStringWithLength
}
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class Button(
    text: ButtonTextStringWithLength,
    value: ButtonValueStringWithLength
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntime.model.Button = {
    import Button.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntime.model.Button
      .builder()
      .text(text: java.lang.String)
      .value(value: java.lang.String)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.lexruntime.model.Button.ReadOnly =
    io.github.vigoo.zioaws.lexruntime.model.Button.wrap(buildAwsValue())
}
object Button {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.lexruntime.model.Button] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lexruntime.model.Button =
      io.github.vigoo.zioaws.lexruntime.model.Button(textValue, valueValue)
    def textValue: ButtonTextStringWithLength
    def valueValue: ButtonValueStringWithLength
    def text: ZIO[Any, Nothing, ButtonTextStringWithLength] =
      ZIO.succeed(textValue)
    def value: ZIO[Any, Nothing, ButtonValueStringWithLength] =
      ZIO.succeed(valueValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lexruntime.model.Button
  ) extends io.github.vigoo.zioaws.lexruntime.model.Button.ReadOnly {
    override def textValue: ButtonTextStringWithLength =
      impl.text(): ButtonTextStringWithLength
    override def valueValue: ButtonValueStringWithLength =
      impl.value(): ButtonValueStringWithLength
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntime.model.Button
  ): io.github.vigoo.zioaws.lexruntime.model.Button.ReadOnly = new Wrapper(impl)
}
