package io.github.vigoo.zioaws.lexruntime.model
import io.github.vigoo.zioaws.lexruntime.model.primitives.{
  BotVersion,
  Text,
  IntentName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PostTextResponse(
    intentName: Option[IntentName] = None,
    nluIntentConfidence: Option[
      io.github.vigoo.zioaws.lexruntime.model.IntentConfidence
    ] = None,
    alternativeIntents: Option[
      Iterable[io.github.vigoo.zioaws.lexruntime.model.PredictedIntent]
    ] = None,
    slots: Option[Map[String, String]] = None,
    sessionAttributes: Option[Map[String, String]] = None,
    message: Option[Text] = None,
    sentimentResponse: Option[
      io.github.vigoo.zioaws.lexruntime.model.SentimentResponse
    ] = None,
    messageFormat: Option[
      io.github.vigoo.zioaws.lexruntime.model.MessageFormatType
    ] = None,
    dialogState: Option[io.github.vigoo.zioaws.lexruntime.model.DialogState] =
      None,
    slotToElicit: Option[String] = None,
    responseCard: Option[io.github.vigoo.zioaws.lexruntime.model.ResponseCard] =
      None,
    sessionId: Option[String] = None,
    botVersion: Option[BotVersion] = None,
    activeContexts: Option[
      Iterable[io.github.vigoo.zioaws.lexruntime.model.ActiveContext]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntime.model.PostTextResponse = {
    import PostTextResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntime.model.PostTextResponse
      .builder()
      .optionallyWith(intentName.map(value => value: java.lang.String))(
        _.intentName
      )
      .optionallyWith(nluIntentConfidence.map(value => value.buildAwsValue()))(
        _.nluIntentConfidence
      )
      .optionallyWith(
        alternativeIntents.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.alternativeIntents)
      .optionallyWith(
        slots.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.slots)
      .optionallyWith(
        sessionAttributes.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.sessionAttributes)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .optionallyWith(sentimentResponse.map(value => value.buildAwsValue()))(
        _.sentimentResponse
      )
      .optionallyWith(messageFormat.map(value => value.unwrap))(_.messageFormat)
      .optionallyWith(dialogState.map(value => value.unwrap))(_.dialogState)
      .optionallyWith(slotToElicit.map(value => value: java.lang.String))(
        _.slotToElicit
      )
      .optionallyWith(responseCard.map(value => value.buildAwsValue()))(
        _.responseCard
      )
      .optionallyWith(sessionId.map(value => value: java.lang.String))(
        _.sessionId
      )
      .optionallyWith(botVersion.map(value => value: java.lang.String))(
        _.botVersion
      )
      .optionallyWith(
        activeContexts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.activeContexts)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lexruntime.model.PostTextResponse.ReadOnly =
    io.github.vigoo.zioaws.lexruntime.model.PostTextResponse
      .wrap(buildAwsValue())
}
object PostTextResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntime.model.PostTextResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lexruntime.model.PostTextResponse =
      io.github.vigoo.zioaws.lexruntime.model.PostTextResponse(
        intentNameValue.map(value => value),
        nluIntentConfidenceValue.map(value => value.editable),
        alternativeIntentsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        slotsValue.map(value => value),
        sessionAttributesValue.map(value => value),
        messageValue.map(value => value),
        sentimentResponseValue.map(value => value.editable),
        messageFormatValue.map(value => value),
        dialogStateValue.map(value => value),
        slotToElicitValue.map(value => value),
        responseCardValue.map(value => value.editable),
        sessionIdValue.map(value => value),
        botVersionValue.map(value => value),
        activeContextsValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def intentNameValue: Option[IntentName]
    def nluIntentConfidenceValue: Option[
      io.github.vigoo.zioaws.lexruntime.model.IntentConfidence.ReadOnly
    ]
    def alternativeIntentsValue: Option[
      List[io.github.vigoo.zioaws.lexruntime.model.PredictedIntent.ReadOnly]
    ]
    def slotsValue: Option[Map[String, String]]
    def sessionAttributesValue: Option[Map[String, String]]
    def messageValue: Option[Text]
    def sentimentResponseValue: Option[
      io.github.vigoo.zioaws.lexruntime.model.SentimentResponse.ReadOnly
    ]
    def messageFormatValue
        : Option[io.github.vigoo.zioaws.lexruntime.model.MessageFormatType]
    def dialogStateValue
        : Option[io.github.vigoo.zioaws.lexruntime.model.DialogState]
    def slotToElicitValue: Option[String]
    def responseCardValue
        : Option[io.github.vigoo.zioaws.lexruntime.model.ResponseCard.ReadOnly]
    def sessionIdValue: Option[String]
    def botVersionValue: Option[BotVersion]
    def activeContextsValue: Option[
      List[io.github.vigoo.zioaws.lexruntime.model.ActiveContext.ReadOnly]
    ]
    def intentName: ZIO[Any, AwsError, IntentName] =
      AwsError.unwrapOptionField("intentName", intentNameValue)
    def nluIntentConfidence: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lexruntime.model.IntentConfidence.ReadOnly
    ] = AwsError.unwrapOptionField(
      "nluIntentConfidence",
      nluIntentConfidenceValue
    )
    def alternativeIntents: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lexruntime.model.PredictedIntent.ReadOnly
    ]] =
      AwsError.unwrapOptionField("alternativeIntents", alternativeIntentsValue)
    def slots: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("slots", slotsValue)
    def sessionAttributes: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("sessionAttributes", sessionAttributesValue)
    def message: ZIO[Any, AwsError, Text] =
      AwsError.unwrapOptionField("message", messageValue)
    def sentimentResponse: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lexruntime.model.SentimentResponse.ReadOnly
    ] = AwsError.unwrapOptionField("sentimentResponse", sentimentResponseValue)
    def messageFormat: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lexruntime.model.MessageFormatType
    ] = AwsError.unwrapOptionField("messageFormat", messageFormatValue)
    def dialogState: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lexruntime.model.DialogState
    ] = AwsError.unwrapOptionField("dialogState", dialogStateValue)
    def slotToElicit: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("slotToElicit", slotToElicitValue)
    def responseCard: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lexruntime.model.ResponseCard.ReadOnly
    ] = AwsError.unwrapOptionField("responseCard", responseCardValue)
    def sessionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sessionId", sessionIdValue)
    def botVersion: ZIO[Any, AwsError, BotVersion] =
      AwsError.unwrapOptionField("botVersion", botVersionValue)
    def activeContexts: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lexruntime.model.ActiveContext.ReadOnly
    ]] = AwsError.unwrapOptionField("activeContexts", activeContextsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lexruntime.model.PostTextResponse
  ) extends io.github.vigoo.zioaws.lexruntime.model.PostTextResponse.ReadOnly {
    override def intentNameValue: Option[IntentName] =
      scala.Option(impl.intentName()).map(value => value: IntentName)
    override def nluIntentConfidenceValue: Option[
      io.github.vigoo.zioaws.lexruntime.model.IntentConfidence.ReadOnly
    ] = scala
      .Option(impl.nluIntentConfidence())
      .map(value =>
        io.github.vigoo.zioaws.lexruntime.model.IntentConfidence.wrap(value)
      )
    override def alternativeIntentsValue: Option[
      List[io.github.vigoo.zioaws.lexruntime.model.PredictedIntent.ReadOnly]
    ] = scala
      .Option(impl.alternativeIntents())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lexruntime.model.PredictedIntent.wrap(item)
        }.toList
      )
    override def slotsValue: Option[Map[String, String]] = scala
      .Option(impl.slots())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override def sessionAttributesValue: Option[Map[String, String]] = scala
      .Option(impl.sessionAttributes())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override def messageValue: Option[Text] =
      scala.Option(impl.message()).map(value => value: Text)
    override def sentimentResponseValue: Option[
      io.github.vigoo.zioaws.lexruntime.model.SentimentResponse.ReadOnly
    ] = scala
      .Option(impl.sentimentResponse())
      .map(value =>
        io.github.vigoo.zioaws.lexruntime.model.SentimentResponse.wrap(value)
      )
    override def messageFormatValue
        : Option[io.github.vigoo.zioaws.lexruntime.model.MessageFormatType] =
      scala
        .Option(impl.messageFormat())
        .map(value =>
          io.github.vigoo.zioaws.lexruntime.model.MessageFormatType.wrap(value)
        )
    override def dialogStateValue
        : Option[io.github.vigoo.zioaws.lexruntime.model.DialogState] = scala
      .Option(impl.dialogState())
      .map(value =>
        io.github.vigoo.zioaws.lexruntime.model.DialogState.wrap(value)
      )
    override def slotToElicitValue: Option[String] =
      scala.Option(impl.slotToElicit()).map(value => value: String)
    override def responseCardValue: Option[
      io.github.vigoo.zioaws.lexruntime.model.ResponseCard.ReadOnly
    ] = scala
      .Option(impl.responseCard())
      .map(value =>
        io.github.vigoo.zioaws.lexruntime.model.ResponseCard.wrap(value)
      )
    override def sessionIdValue: Option[String] =
      scala.Option(impl.sessionId()).map(value => value: String)
    override def botVersionValue: Option[BotVersion] =
      scala.Option(impl.botVersion()).map(value => value: BotVersion)
    override def activeContextsValue: Option[
      List[io.github.vigoo.zioaws.lexruntime.model.ActiveContext.ReadOnly]
    ] = scala
      .Option(impl.activeContexts())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lexruntime.model.ActiveContext.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntime.model.PostTextResponse
  ): io.github.vigoo.zioaws.lexruntime.model.PostTextResponse.ReadOnly =
    new Wrapper(impl)
}
