package io.github.vigoo.zioaws.lexruntime.model
import io.github.vigoo.zioaws.lexruntime.model.primitives.{
  Accept,
  UserId,
  BotAlias,
  BotName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PutSessionRequest(
    botName: BotName,
    botAlias: BotAlias,
    userId: UserId,
    sessionAttributes: Option[Map[String, String]] = None,
    dialogAction: Option[io.github.vigoo.zioaws.lexruntime.model.DialogAction] =
      None,
    recentIntentSummaryView: Option[
      Iterable[io.github.vigoo.zioaws.lexruntime.model.IntentSummary]
    ] = None,
    accept: Option[Accept] = None,
    activeContexts: Option[
      Iterable[io.github.vigoo.zioaws.lexruntime.model.ActiveContext]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntime.model.PutSessionRequest = {
    import PutSessionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntime.model.PutSessionRequest
      .builder()
      .botName(botName: java.lang.String)
      .botAlias(botAlias: java.lang.String)
      .userId(userId: java.lang.String)
      .optionallyWith(
        sessionAttributes.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.sessionAttributes)
      .optionallyWith(dialogAction.map(value => value.buildAwsValue()))(
        _.dialogAction
      )
      .optionallyWith(
        recentIntentSummaryView.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recentIntentSummaryView)
      .optionallyWith(accept.map(value => value: java.lang.String))(_.accept)
      .optionallyWith(
        activeContexts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.activeContexts)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lexruntime.model.PutSessionRequest.ReadOnly =
    io.github.vigoo.zioaws.lexruntime.model.PutSessionRequest
      .wrap(buildAwsValue())
}
object PutSessionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntime.model.PutSessionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lexruntime.model.PutSessionRequest =
      io.github.vigoo.zioaws.lexruntime.model.PutSessionRequest(
        botNameValue,
        botAliasValue,
        userIdValue,
        sessionAttributesValue.map(value => value),
        dialogActionValue.map(value => value.editable),
        recentIntentSummaryViewValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        acceptValue.map(value => value),
        activeContextsValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def botNameValue: BotName
    def botAliasValue: BotAlias
    def userIdValue: UserId
    def sessionAttributesValue: Option[Map[String, String]]
    def dialogActionValue
        : Option[io.github.vigoo.zioaws.lexruntime.model.DialogAction.ReadOnly]
    def recentIntentSummaryViewValue: Option[
      List[io.github.vigoo.zioaws.lexruntime.model.IntentSummary.ReadOnly]
    ]
    def acceptValue: Option[Accept]
    def activeContextsValue: Option[
      List[io.github.vigoo.zioaws.lexruntime.model.ActiveContext.ReadOnly]
    ]
    def botName: ZIO[Any, Nothing, BotName] = ZIO.succeed(botNameValue)
    def botAlias: ZIO[Any, Nothing, BotAlias] = ZIO.succeed(botAliasValue)
    def userId: ZIO[Any, Nothing, UserId] = ZIO.succeed(userIdValue)
    def sessionAttributes: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("sessionAttributes", sessionAttributesValue)
    def dialogAction: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lexruntime.model.DialogAction.ReadOnly
    ] = AwsError.unwrapOptionField("dialogAction", dialogActionValue)
    def recentIntentSummaryView: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lexruntime.model.IntentSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "recentIntentSummaryView",
      recentIntentSummaryViewValue
    )
    def accept: ZIO[Any, AwsError, Accept] =
      AwsError.unwrapOptionField("accept", acceptValue)
    def activeContexts: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lexruntime.model.ActiveContext.ReadOnly
    ]] = AwsError.unwrapOptionField("activeContexts", activeContextsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lexruntime.model.PutSessionRequest
  ) extends io.github.vigoo.zioaws.lexruntime.model.PutSessionRequest.ReadOnly {
    override def botNameValue: BotName = impl.botName(): BotName
    override def botAliasValue: BotAlias = impl.botAlias(): BotAlias
    override def userIdValue: UserId = impl.userId(): UserId
    override def sessionAttributesValue: Option[Map[String, String]] = scala
      .Option(impl.sessionAttributes())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override def dialogActionValue: Option[
      io.github.vigoo.zioaws.lexruntime.model.DialogAction.ReadOnly
    ] = scala
      .Option(impl.dialogAction())
      .map(value =>
        io.github.vigoo.zioaws.lexruntime.model.DialogAction.wrap(value)
      )
    override def recentIntentSummaryViewValue: Option[
      List[io.github.vigoo.zioaws.lexruntime.model.IntentSummary.ReadOnly]
    ] = scala
      .Option(impl.recentIntentSummaryView())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lexruntime.model.IntentSummary.wrap(item)
        }.toList
      )
    override def acceptValue: Option[Accept] =
      scala.Option(impl.accept()).map(value => value: Accept)
    override def activeContextsValue: Option[
      List[io.github.vigoo.zioaws.lexruntime.model.ActiveContext.ReadOnly]
    ] = scala
      .Option(impl.activeContexts())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lexruntime.model.ActiveContext.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntime.model.PutSessionRequest
  ): io.github.vigoo.zioaws.lexruntime.model.PutSessionRequest.ReadOnly =
    new Wrapper(impl)
}
