package io.github.vigoo.zioaws.lexruntime.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ResponseCard(
    version: Option[String] = None,
    contentType: Option[io.github.vigoo.zioaws.lexruntime.model.ContentType] =
      None,
    genericAttachments: Option[
      Iterable[io.github.vigoo.zioaws.lexruntime.model.GenericAttachment]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntime.model.ResponseCard = {
    import ResponseCard.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntime.model.ResponseCard
      .builder()
      .optionallyWith(version.map(value => value: java.lang.String))(_.version)
      .optionallyWith(contentType.map(value => value.unwrap))(_.contentType)
      .optionallyWith(
        genericAttachments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.genericAttachments)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lexruntime.model.ResponseCard.ReadOnly =
    io.github.vigoo.zioaws.lexruntime.model.ResponseCard.wrap(buildAwsValue())
}
object ResponseCard {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntime.model.ResponseCard
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lexruntime.model.ResponseCard =
      io.github.vigoo.zioaws.lexruntime.model.ResponseCard(
        versionValue.map(value => value),
        contentTypeValue.map(value => value),
        genericAttachmentsValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def versionValue: Option[String]
    def contentTypeValue
        : Option[io.github.vigoo.zioaws.lexruntime.model.ContentType]
    def genericAttachmentsValue: Option[
      List[io.github.vigoo.zioaws.lexruntime.model.GenericAttachment.ReadOnly]
    ]
    def version: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("version", versionValue)
    def contentType: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lexruntime.model.ContentType
    ] = AwsError.unwrapOptionField("contentType", contentTypeValue)
    def genericAttachments: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lexruntime.model.GenericAttachment.ReadOnly
    ]] =
      AwsError.unwrapOptionField("genericAttachments", genericAttachmentsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lexruntime.model.ResponseCard
  ) extends io.github.vigoo.zioaws.lexruntime.model.ResponseCard.ReadOnly {
    override def versionValue: Option[String] =
      scala.Option(impl.version()).map(value => value: String)
    override def contentTypeValue
        : Option[io.github.vigoo.zioaws.lexruntime.model.ContentType] = scala
      .Option(impl.contentType())
      .map(value =>
        io.github.vigoo.zioaws.lexruntime.model.ContentType.wrap(value)
      )
    override def genericAttachmentsValue: Option[
      List[io.github.vigoo.zioaws.lexruntime.model.GenericAttachment.ReadOnly]
    ] = scala
      .Option(impl.genericAttachments())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lexruntime.model.GenericAttachment.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntime.model.ResponseCard
  ): io.github.vigoo.zioaws.lexruntime.model.ResponseCard.ReadOnly =
    new Wrapper(impl)
}
