package io.github.vigoo.zioaws.lexruntime.model
import scala.jdk.CollectionConverters.*
sealed trait FulfillmentState {
  def unwrap: software.amazon.awssdk.services.lexruntime.model.FulfillmentState
}
object FulfillmentState {
  def wrap(
      value: software.amazon.awssdk.services.lexruntime.model.FulfillmentState
  ): io.github.vigoo.zioaws.lexruntime.model.FulfillmentState = value match {
    case software.amazon.awssdk.services.lexruntime.model.FulfillmentState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lexruntime.model.FulfillmentState.FULFILLED =>
      val r = Fulfilled
      r
    case software.amazon.awssdk.services.lexruntime.model.FulfillmentState.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.lexruntime.model.FulfillmentState.READY_FOR_FULFILLMENT =>
      val r = ReadyForFulfillment
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.lexruntime.model.FulfillmentState {
    override def unwrap
        : software.amazon.awssdk.services.lexruntime.model.FulfillmentState =
      software.amazon.awssdk.services.lexruntime.model.FulfillmentState.UNKNOWN_TO_SDK_VERSION
  }
  case object Fulfilled
      extends io.github.vigoo.zioaws.lexruntime.model.FulfillmentState {
    override def unwrap
        : software.amazon.awssdk.services.lexruntime.model.FulfillmentState =
      software.amazon.awssdk.services.lexruntime.model.FulfillmentState.FULFILLED
  }
  case object Failed
      extends io.github.vigoo.zioaws.lexruntime.model.FulfillmentState {
    override def unwrap
        : software.amazon.awssdk.services.lexruntime.model.FulfillmentState =
      software.amazon.awssdk.services.lexruntime.model.FulfillmentState.FAILED
  }
  case object ReadyForFulfillment
      extends io.github.vigoo.zioaws.lexruntime.model.FulfillmentState {
    override def unwrap
        : software.amazon.awssdk.services.lexruntime.model.FulfillmentState =
      software.amazon.awssdk.services.lexruntime.model.FulfillmentState.READY_FOR_FULFILLMENT
  }
}
