package io.github.vigoo.zioaws.lexruntime.model
import scala.jdk.CollectionConverters.*
sealed trait DialogState {
  def unwrap: software.amazon.awssdk.services.lexruntime.model.DialogState
}
object DialogState {
  def wrap(
      value: software.amazon.awssdk.services.lexruntime.model.DialogState
  ): io.github.vigoo.zioaws.lexruntime.model.DialogState = value match {
    case software.amazon.awssdk.services.lexruntime.model.DialogState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lexruntime.model.DialogState.ELICIT_INTENT =>
      val r = ElicitIntent
      r
    case software.amazon.awssdk.services.lexruntime.model.DialogState.CONFIRM_INTENT =>
      val r = ConfirmIntent
      r
    case software.amazon.awssdk.services.lexruntime.model.DialogState.ELICIT_SLOT =>
      val r = ElicitSlot
      r
    case software.amazon.awssdk.services.lexruntime.model.DialogState.FULFILLED =>
      val r = Fulfilled
      r
    case software.amazon.awssdk.services.lexruntime.model.DialogState.READY_FOR_FULFILLMENT =>
      val r = ReadyForFulfillment
      r
    case software.amazon.awssdk.services.lexruntime.model.DialogState.FAILED =>
      val r = Failed
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.lexruntime.model.DialogState {
    override def unwrap
        : software.amazon.awssdk.services.lexruntime.model.DialogState =
      software.amazon.awssdk.services.lexruntime.model.DialogState.UNKNOWN_TO_SDK_VERSION
  }
  case object ElicitIntent
      extends io.github.vigoo.zioaws.lexruntime.model.DialogState {
    override def unwrap
        : software.amazon.awssdk.services.lexruntime.model.DialogState =
      software.amazon.awssdk.services.lexruntime.model.DialogState.ELICIT_INTENT
  }
  case object ConfirmIntent
      extends io.github.vigoo.zioaws.lexruntime.model.DialogState {
    override def unwrap
        : software.amazon.awssdk.services.lexruntime.model.DialogState =
      software.amazon.awssdk.services.lexruntime.model.DialogState.CONFIRM_INTENT
  }
  case object ElicitSlot
      extends io.github.vigoo.zioaws.lexruntime.model.DialogState {
    override def unwrap
        : software.amazon.awssdk.services.lexruntime.model.DialogState =
      software.amazon.awssdk.services.lexruntime.model.DialogState.ELICIT_SLOT
  }
  case object Fulfilled
      extends io.github.vigoo.zioaws.lexruntime.model.DialogState {
    override def unwrap
        : software.amazon.awssdk.services.lexruntime.model.DialogState =
      software.amazon.awssdk.services.lexruntime.model.DialogState.FULFILLED
  }
  case object ReadyForFulfillment
      extends io.github.vigoo.zioaws.lexruntime.model.DialogState {
    override def unwrap
        : software.amazon.awssdk.services.lexruntime.model.DialogState =
      software.amazon.awssdk.services.lexruntime.model.DialogState.READY_FOR_FULFILLMENT
  }
  case object Failed
      extends io.github.vigoo.zioaws.lexruntime.model.DialogState {
    override def unwrap
        : software.amazon.awssdk.services.lexruntime.model.DialogState =
      software.amazon.awssdk.services.lexruntime.model.DialogState.FAILED
  }
}
