package io.github.vigoo.zioaws.lexruntime.model
import io.github.vigoo.zioaws.lexruntime.model.primitives.{
  UserId,
  BotAlias,
  BotName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteSessionRequest(
    botName: BotName,
    botAlias: BotAlias,
    userId: UserId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntime.model.DeleteSessionRequest = {
    import DeleteSessionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntime.model.DeleteSessionRequest
      .builder()
      .botName(botName: java.lang.String)
      .botAlias(botAlias: java.lang.String)
      .userId(userId: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lexruntime.model.DeleteSessionRequest.ReadOnly =
    io.github.vigoo.zioaws.lexruntime.model.DeleteSessionRequest
      .wrap(buildAwsValue())
}
object DeleteSessionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntime.model.DeleteSessionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lexruntime.model.DeleteSessionRequest =
      io.github.vigoo.zioaws.lexruntime.model
        .DeleteSessionRequest(botNameValue, botAliasValue, userIdValue)
    def botNameValue: BotName
    def botAliasValue: BotAlias
    def userIdValue: UserId
    def botName: ZIO[Any, Nothing, BotName] = ZIO.succeed(botNameValue)
    def botAlias: ZIO[Any, Nothing, BotAlias] = ZIO.succeed(botAliasValue)
    def userId: ZIO[Any, Nothing, UserId] = ZIO.succeed(userIdValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lexruntime.model.DeleteSessionRequest
  ) extends io.github.vigoo.zioaws.lexruntime.model.DeleteSessionRequest.ReadOnly {
    override def botNameValue: BotName = impl.botName(): BotName
    override def botAliasValue: BotAlias = impl.botAlias(): BotAlias
    override def userIdValue: UserId = impl.userId(): UserId
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntime.model.DeleteSessionRequest
  ): io.github.vigoo.zioaws.lexruntime.model.DeleteSessionRequest.ReadOnly =
    new Wrapper(impl)
}
