package io.github.vigoo.zioaws.lexruntime.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ResponseCard(version: scala.Option[String] = None, contentType: scala.Option[ContentType] = None, genericAttachments: scala.Option[Iterable[GenericAttachment]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lexruntime.model.ResponseCard = {
    import ResponseCard.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntime.model.ResponseCard.builder().optionallyWith(version.map(value => value: java.lang.String))(_.version).optionallyWith(contentType.map(value => value.unwrap))(_.contentType).optionallyWith(genericAttachments.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.genericAttachments).build()
  }
  def asReadOnly: ResponseCard.ReadOnly = ResponseCard.wrap(buildAwsValue())
}
object ResponseCard {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lexruntime.model.ResponseCard] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ResponseCard = ResponseCard(versionValue.map(value => value), contentTypeValue.map(value => value), genericAttachmentsValue.map(value => value.map { item => 
      item.editable
    }))
    def versionValue: scala.Option[String]
    def contentTypeValue: scala.Option[ContentType]
    def genericAttachmentsValue: scala.Option[List[GenericAttachment.ReadOnly]]
    def version: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("version", versionValue)
    def contentType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ContentType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("contentType", contentTypeValue)
    def genericAttachments: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[GenericAttachment.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("genericAttachments", genericAttachmentsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lexruntime.model.ResponseCard) extends ResponseCard.ReadOnly {
    override def versionValue: scala.Option[String] = scala.Option(impl.version()).map(value => value: String)
    override def contentTypeValue: scala.Option[ContentType] = scala.Option(impl.contentType()).map(value => ContentType.wrap(value))
    override def genericAttachmentsValue: scala.Option[List[GenericAttachment.ReadOnly]] = scala.Option(impl.genericAttachments()).map(value => value.asScala.map { item => 
      GenericAttachment.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.lexruntime.model.ResponseCard): ReadOnly = new Wrapper(impl)
}