package io.github.vigoo.zioaws.lexruntime.model
import io.github.vigoo.zioaws.lexruntime.model.primitives.{
  IntentSummaryCheckpointLabel,
  UserId,
  BotAlias,
  BotName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetSessionRequest(
    botName: BotName,
    botAlias: BotAlias,
    userId: UserId,
    checkpointLabelFilter: Option[IntentSummaryCheckpointLabel] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntime.model.GetSessionRequest = {
    import GetSessionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntime.model.GetSessionRequest
      .builder()
      .botName(botName: java.lang.String)
      .botAlias(botAlias: java.lang.String)
      .userId(userId: java.lang.String)
      .optionallyWith(
        checkpointLabelFilter.map(value => value: java.lang.String)
      )(_.checkpointLabelFilter)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lexruntime.model.GetSessionRequest.ReadOnly =
    io.github.vigoo.zioaws.lexruntime.model.GetSessionRequest
      .wrap(buildAwsValue())
}
object GetSessionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntime.model.GetSessionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lexruntime.model.GetSessionRequest =
      io.github.vigoo.zioaws.lexruntime.model.GetSessionRequest(
        botNameValue,
        botAliasValue,
        userIdValue,
        checkpointLabelFilterValue.map(value => value)
      )
    def botNameValue: BotName
    def botAliasValue: BotAlias
    def userIdValue: UserId
    def checkpointLabelFilterValue: Option[IntentSummaryCheckpointLabel]
    def botName: ZIO[Any, Nothing, BotName] = ZIO.succeed(botNameValue)
    def botAlias: ZIO[Any, Nothing, BotAlias] = ZIO.succeed(botAliasValue)
    def userId: ZIO[Any, Nothing, UserId] = ZIO.succeed(userIdValue)
    def checkpointLabelFilter
        : ZIO[Any, AwsError, IntentSummaryCheckpointLabel] = AwsError
      .unwrapOptionField("checkpointLabelFilter", checkpointLabelFilterValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lexruntime.model.GetSessionRequest
  ) extends io.github.vigoo.zioaws.lexruntime.model.GetSessionRequest.ReadOnly {
    override def botNameValue: BotName = impl.botName(): BotName
    override def botAliasValue: BotAlias = impl.botAlias(): BotAlias
    override def userIdValue: UserId = impl.userId(): UserId
    override def checkpointLabelFilterValue
        : Option[IntentSummaryCheckpointLabel] = scala
      .Option(impl.checkpointLabelFilter())
      .map(value => value: IntentSummaryCheckpointLabel)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntime.model.GetSessionRequest
  ): io.github.vigoo.zioaws.lexruntime.model.GetSessionRequest.ReadOnly =
    new Wrapper(impl)
}
