package io.github.vigoo.zioaws.lexruntime.model
import io.github.vigoo.zioaws.lexruntime.model.primitives.{
  SentimentScore,
  SentimentLabel
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SentimentResponse(
    sentimentLabel: Option[SentimentLabel] = None,
    sentimentScore: Option[SentimentScore] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntime.model.SentimentResponse = {
    import SentimentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntime.model.SentimentResponse
      .builder()
      .optionallyWith(sentimentLabel.map(value => value: java.lang.String))(
        _.sentimentLabel
      )
      .optionallyWith(sentimentScore.map(value => value: java.lang.String))(
        _.sentimentScore
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lexruntime.model.SentimentResponse.ReadOnly =
    io.github.vigoo.zioaws.lexruntime.model.SentimentResponse
      .wrap(buildAwsValue())
}
object SentimentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntime.model.SentimentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lexruntime.model.SentimentResponse =
      io.github.vigoo.zioaws.lexruntime.model.SentimentResponse(
        sentimentLabelValue.map(value => value),
        sentimentScoreValue.map(value => value)
      )
    def sentimentLabelValue: Option[SentimentLabel]
    def sentimentScoreValue: Option[SentimentScore]
    def sentimentLabel: ZIO[Any, AwsError, SentimentLabel] =
      AwsError.unwrapOptionField("sentimentLabel", sentimentLabelValue)
    def sentimentScore: ZIO[Any, AwsError, SentimentScore] =
      AwsError.unwrapOptionField("sentimentScore", sentimentScoreValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lexruntime.model.SentimentResponse
  ) extends io.github.vigoo.zioaws.lexruntime.model.SentimentResponse.ReadOnly {
    override def sentimentLabelValue: Option[SentimentLabel] =
      scala.Option(impl.sentimentLabel()).map(value => value: SentimentLabel)
    override def sentimentScoreValue: Option[SentimentScore] =
      scala.Option(impl.sentimentScore()).map(value => value: SentimentScore)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntime.model.SentimentResponse
  ): io.github.vigoo.zioaws.lexruntime.model.SentimentResponse.ReadOnly =
    new Wrapper(impl)
}
