package io.github.vigoo.zioaws
import io.github.vigoo.zioaws.lexruntime.LexRuntime
import io.github.vigoo.zioaws.lexruntime.model.{
  PostContentRequest,
  DeleteSessionRequest,
  GetSessionRequest,
  PutSessionRequest,
  PostTextRequest
}
import io.github.vigoo.zioaws.core.{
  AwsServiceBase,
  StreamingOutputResult,
  AwsError
}
import software.amazon.awssdk.services.lexruntime.{
  LexRuntimeAsyncClientBuilder,
  LexRuntimeAsyncClient
}
import io.github.vigoo.zioaws.lexruntime.model.DeleteSessionResponse.ReadOnly
import io.github.vigoo.zioaws.core.config.AwsConfig
import zio.{Task, ZManaged, IO, ZIO, ZLayer, URLayer, Has}
import io.github.vigoo.zioaws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.stream.ZStream
import software.amazon.awssdk.services.lexruntime.model.{
  PostTextResponse,
  DeleteSessionResponse,
  GetSessionResponse,
  PostContentResponse,
  PutSessionResponse
}
import zio.test.mock.{Proxy, Mock}
package object lexruntime {
  import scala.jdk.CollectionConverters.*
  type LexRuntime = Has[LexRuntime.Service]
  object LexRuntime {
    trait Service extends AspectSupport[Service] {
      val api: LexRuntimeAsyncClient
      def deleteSession(request: DeleteSessionRequest): IO[AwsError, ReadOnly]
      def postText(request: PostTextRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lexruntime.model.PostTextResponse.ReadOnly
      ]
      def postContent(
          request: PostContentRequest,
          body: ZStream[Any, AwsError, Byte]
      ): IO[AwsError, StreamingOutputResult[
        Any,
        io.github.vigoo.zioaws.lexruntime.model.PostContentResponse.ReadOnly,
        Byte
      ]]
      def putSession(
          request: PutSessionRequest
      ): IO[AwsError, StreamingOutputResult[
        Any,
        io.github.vigoo.zioaws.lexruntime.model.PutSessionResponse.ReadOnly,
        Byte
      ]]
      def getSession(request: GetSessionRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lexruntime.model.GetSessionResponse.ReadOnly
      ]
    }
    object LexRuntimeMock extends Mock[LexRuntime] {
      object DeleteSession
          extends Effect[DeleteSessionRequest, AwsError, ReadOnly]
      object PostText
          extends Effect[
            PostTextRequest,
            AwsError,
            io.github.vigoo.zioaws.lexruntime.model.PostTextResponse.ReadOnly
          ]
      object PostContent
          extends Effect[Tuple2[
            PostContentRequest,
            ZStream[Any, AwsError, Byte]
          ], AwsError, StreamingOutputResult[
            Any,
            io.github.vigoo.zioaws.lexruntime.model.PostContentResponse.ReadOnly,
            Byte
          ]]
      object PutSession
          extends Effect[PutSessionRequest, AwsError, StreamingOutputResult[
            Any,
            io.github.vigoo.zioaws.lexruntime.model.PutSessionResponse.ReadOnly,
            Byte
          ]]
      object GetSession
          extends Effect[
            GetSessionRequest,
            AwsError,
            io.github.vigoo.zioaws.lexruntime.model.GetSessionResponse.ReadOnly
          ]
      val compose: URLayer[Has[Proxy], LexRuntime] = ZLayer.fromServiceM {
        proxy =>
          withRuntime.map { rts =>
            new LexRuntime.Service {
              val api: LexRuntimeAsyncClient = null
              def withAspect[R1](
                  newAspect: AwsCallAspect[R1],
                  r: R1
              ): LexRuntime.Service = this
              def deleteSession(
                  request: DeleteSessionRequest
              ): IO[AwsError, ReadOnly] = proxy(DeleteSession, request)
              def postText(request: PostTextRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lexruntime.model.PostTextResponse.ReadOnly
              ] = proxy(PostText, request)
              def postContent(
                  request: PostContentRequest,
                  body: ZStream[Any, AwsError, Byte]
              ): IO[AwsError, StreamingOutputResult[
                Any,
                io.github.vigoo.zioaws.lexruntime.model.PostContentResponse.ReadOnly,
                Byte
              ]] = proxy(PostContent, request, body)
              def putSession(
                  request: PutSessionRequest
              ): IO[AwsError, StreamingOutputResult[
                Any,
                io.github.vigoo.zioaws.lexruntime.model.PutSessionResponse.ReadOnly,
                Byte
              ]] = proxy(PutSession, request)
              def getSession(request: GetSessionRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lexruntime.model.GetSessionResponse.ReadOnly
              ] = proxy(GetSession, request)
            }
          }
      }
    }
  }
  val live: ZLayer[AwsConfig, java.lang.Throwable, LexRuntime] = customized(
    identity
  )
  def customized(
      customization: LexRuntimeAsyncClientBuilder => LexRuntimeAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, LexRuntime] = managed(
    customization
  ).toLayer
  def managed(
      customization: LexRuntimeAsyncClientBuilder => LexRuntimeAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, LexRuntime.Service] = for (
    awsConfig <- ZManaged.service[AwsConfig.Service];
    executor <- ZIO.executor.toManaged_;
    builder = LexRuntimeAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[LexRuntimeAsyncClient, LexRuntimeAsyncClientBuilder](builder)
      .toManaged_;
    b1 <- awsConfig
      .configureHttpClient[LexRuntimeAsyncClient, LexRuntimeAsyncClientBuilder](
        b0,
        io.github.vigoo.zioaws.core.httpclient
          .ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged_; client <- zio.ZIO(customization(b1).build()).toManaged_
  )
    yield new LexRuntimeImpl(
      client,
      AwsCallAspect.identity,
      ().asInstanceOf[Any]
    )
  private class LexRuntimeImpl[R](
      override val api: LexRuntimeAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: R
  ) extends LexRuntime.Service
      with AwsServiceBase[R, LexRuntimeImpl] {
    override val serviceName: String = "LexRuntime"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: R1
    ): LexRuntimeImpl[R1] = new LexRuntimeImpl(api, newAspect, r)
    def deleteSession(request: DeleteSessionRequest): IO[AwsError, ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lexruntime.model.DeleteSessionRequest,
        DeleteSessionResponse
      ]("deleteSession", api.deleteSession)(request.buildAwsValue())
        .map(io.github.vigoo.zioaws.lexruntime.model.DeleteSessionResponse.wrap)
        .provide(r)
    def postText(request: PostTextRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lexruntime.model.PostTextResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lexruntime.model.PostTextRequest,
      PostTextResponse
    ]("postText", api.postText)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lexruntime.model.PostTextResponse.wrap)
      .provide(r)
    def postContent(
        request: PostContentRequest,
        body: ZStream[Any, AwsError, Byte]
    ): IO[AwsError, StreamingOutputResult[
      Any,
      io.github.vigoo.zioaws.lexruntime.model.PostContentResponse.ReadOnly,
      Byte
    ]] = asyncRequestInputOutputStream[
      software.amazon.awssdk.services.lexruntime.model.PostContentRequest,
      PostContentResponse
    ](
      "postContent",
      api.postContent[Task[StreamingOutputResult[R, PostContentResponse, Byte]]]
    )(request.buildAwsValue(), body)
      .map(
        _.mapResponse(
          io.github.vigoo.zioaws.lexruntime.model.PostContentResponse.wrap
        ).provide(r)
      )
      .provide(r)
    def putSession(
        request: PutSessionRequest
    ): IO[AwsError, StreamingOutputResult[
      Any,
      io.github.vigoo.zioaws.lexruntime.model.PutSessionResponse.ReadOnly,
      Byte
    ]] = asyncRequestOutputStream[
      software.amazon.awssdk.services.lexruntime.model.PutSessionRequest,
      PutSessionResponse
    ](
      "putSession",
      api.putSession[Task[StreamingOutputResult[R, PutSessionResponse, Byte]]]
    )(request.buildAwsValue())
      .map(
        _.mapResponse(
          io.github.vigoo.zioaws.lexruntime.model.PutSessionResponse.wrap
        ).provide(r)
      )
      .provide(r)
    def getSession(request: GetSessionRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lexruntime.model.GetSessionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lexruntime.model.GetSessionRequest,
      GetSessionResponse
    ]("getSession", api.getSession)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lexruntime.model.GetSessionResponse.wrap)
      .provide(r)
  }
  def deleteSession(
      request: DeleteSessionRequest
  ): ZIO[LexRuntime, AwsError, ReadOnly] =
    ZIO.accessM(_.get.deleteSession(request))
  def postText(request: PostTextRequest): ZIO[
    LexRuntime,
    AwsError,
    io.github.vigoo.zioaws.lexruntime.model.PostTextResponse.ReadOnly
  ] = ZIO.accessM(_.get.postText(request))
  def postContent(
      request: PostContentRequest,
      body: ZStream[Any, AwsError, Byte]
  ): ZIO[LexRuntime, AwsError, StreamingOutputResult[
    Any,
    io.github.vigoo.zioaws.lexruntime.model.PostContentResponse.ReadOnly,
    Byte
  ]] = ZIO.accessM(_.get.postContent(request, body))
  def putSession(
      request: PutSessionRequest
  ): ZIO[LexRuntime, AwsError, StreamingOutputResult[
    Any,
    io.github.vigoo.zioaws.lexruntime.model.PutSessionResponse.ReadOnly,
    Byte
  ]] = ZIO.accessM(_.get.putSession(request))
  def getSession(request: GetSessionRequest): ZIO[
    LexRuntime,
    AwsError,
    io.github.vigoo.zioaws.lexruntime.model.GetSessionResponse.ReadOnly
  ] = ZIO.accessM(_.get.getSession(request))
}
