package io.github.vigoo.zioaws.lexruntime.model
import io.github.vigoo.zioaws.lexruntime.model.primitives.IntentName
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PredictedIntent(
    intentName: Option[IntentName] = None,
    nluIntentConfidence: Option[
      io.github.vigoo.zioaws.lexruntime.model.IntentConfidence
    ] = None,
    slots: Option[Map[String, String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntime.model.PredictedIntent = {
    import PredictedIntent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntime.model.PredictedIntent
      .builder()
      .optionallyWith(intentName.map(value => value: java.lang.String))(
        _.intentName
      )
      .optionallyWith(nluIntentConfidence.map(value => value.buildAwsValue()))(
        _.nluIntentConfidence
      )
      .optionallyWith(
        slots.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.slots)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lexruntime.model.PredictedIntent.ReadOnly =
    io.github.vigoo.zioaws.lexruntime.model.PredictedIntent
      .wrap(buildAwsValue())
}
object PredictedIntent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntime.model.PredictedIntent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lexruntime.model.PredictedIntent =
      io.github.vigoo.zioaws.lexruntime.model.PredictedIntent(
        intentNameValue.map(value => value),
        nluIntentConfidenceValue.map(value => value.editable),
        slotsValue.map(value => value)
      )
    def intentNameValue: Option[IntentName]
    def nluIntentConfidenceValue: Option[
      io.github.vigoo.zioaws.lexruntime.model.IntentConfidence.ReadOnly
    ]
    def slotsValue: Option[Map[String, String]]
    def intentName: ZIO[Any, AwsError, IntentName] =
      AwsError.unwrapOptionField("intentName", intentNameValue)
    def nluIntentConfidence: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lexruntime.model.IntentConfidence.ReadOnly
    ] = AwsError.unwrapOptionField(
      "nluIntentConfidence",
      nluIntentConfidenceValue
    )
    def slots: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("slots", slotsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lexruntime.model.PredictedIntent
  ) extends io.github.vigoo.zioaws.lexruntime.model.PredictedIntent.ReadOnly {
    override def intentNameValue: Option[IntentName] =
      scala.Option(impl.intentName()).map(value => value: IntentName)
    override def nluIntentConfidenceValue: Option[
      io.github.vigoo.zioaws.lexruntime.model.IntentConfidence.ReadOnly
    ] = scala
      .Option(impl.nluIntentConfidence())
      .map(value =>
        io.github.vigoo.zioaws.lexruntime.model.IntentConfidence.wrap(value)
      )
    override def slotsValue: Option[Map[String, String]] = scala
      .Option(impl.slots())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntime.model.PredictedIntent
  ): io.github.vigoo.zioaws.lexruntime.model.PredictedIntent.ReadOnly =
    new Wrapper(impl)
}
