package io.github.vigoo.zioaws.lexruntime.model
import io.github.vigoo.zioaws.lexruntime.model.primitives.{
  IntentSummaryCheckpointLabel,
  IntentName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class IntentSummary(
    intentName: Option[IntentName] = None,
    checkpointLabel: Option[IntentSummaryCheckpointLabel] = None,
    slots: Option[Map[String, String]] = None,
    confirmationStatus: Option[
      io.github.vigoo.zioaws.lexruntime.model.ConfirmationStatus
    ] = None,
    dialogActionType: io.github.vigoo.zioaws.lexruntime.model.DialogActionType,
    fulfillmentState: Option[
      io.github.vigoo.zioaws.lexruntime.model.FulfillmentState
    ] = None,
    slotToElicit: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntime.model.IntentSummary = {
    import IntentSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntime.model.IntentSummary
      .builder()
      .optionallyWith(intentName.map(value => value: java.lang.String))(
        _.intentName
      )
      .optionallyWith(checkpointLabel.map(value => value: java.lang.String))(
        _.checkpointLabel
      )
      .optionallyWith(
        slots.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.slots)
      .optionallyWith(confirmationStatus.map(value => value.unwrap))(
        _.confirmationStatus
      )
      .dialogActionType(dialogActionType.unwrap)
      .optionallyWith(fulfillmentState.map(value => value.unwrap))(
        _.fulfillmentState
      )
      .optionallyWith(slotToElicit.map(value => value: java.lang.String))(
        _.slotToElicit
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lexruntime.model.IntentSummary.ReadOnly =
    io.github.vigoo.zioaws.lexruntime.model.IntentSummary.wrap(buildAwsValue())
}
object IntentSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntime.model.IntentSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lexruntime.model.IntentSummary =
      io.github.vigoo.zioaws.lexruntime.model.IntentSummary(
        intentNameValue.map(value => value),
        checkpointLabelValue.map(value => value),
        slotsValue.map(value => value),
        confirmationStatusValue.map(value => value),
        dialogActionTypeValue,
        fulfillmentStateValue.map(value => value),
        slotToElicitValue.map(value => value)
      )
    def intentNameValue: Option[IntentName]
    def checkpointLabelValue: Option[IntentSummaryCheckpointLabel]
    def slotsValue: Option[Map[String, String]]
    def confirmationStatusValue
        : Option[io.github.vigoo.zioaws.lexruntime.model.ConfirmationStatus]
    def dialogActionTypeValue
        : io.github.vigoo.zioaws.lexruntime.model.DialogActionType
    def fulfillmentStateValue
        : Option[io.github.vigoo.zioaws.lexruntime.model.FulfillmentState]
    def slotToElicitValue: Option[String]
    def intentName: ZIO[Any, AwsError, IntentName] =
      AwsError.unwrapOptionField("intentName", intentNameValue)
    def checkpointLabel: ZIO[Any, AwsError, IntentSummaryCheckpointLabel] =
      AwsError.unwrapOptionField("checkpointLabel", checkpointLabelValue)
    def slots: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("slots", slotsValue)
    def confirmationStatus: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lexruntime.model.ConfirmationStatus
    ] =
      AwsError.unwrapOptionField("confirmationStatus", confirmationStatusValue)
    def dialogActionType: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.lexruntime.model.DialogActionType
    ] = ZIO.succeed(dialogActionTypeValue)
    def fulfillmentState: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lexruntime.model.FulfillmentState
    ] = AwsError.unwrapOptionField("fulfillmentState", fulfillmentStateValue)
    def slotToElicit: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("slotToElicit", slotToElicitValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lexruntime.model.IntentSummary
  ) extends io.github.vigoo.zioaws.lexruntime.model.IntentSummary.ReadOnly {
    override def intentNameValue: Option[IntentName] =
      scala.Option(impl.intentName()).map(value => value: IntentName)
    override def checkpointLabelValue: Option[IntentSummaryCheckpointLabel] =
      scala
        .Option(impl.checkpointLabel())
        .map(value => value: IntentSummaryCheckpointLabel)
    override def slotsValue: Option[Map[String, String]] = scala
      .Option(impl.slots())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override def confirmationStatusValue
        : Option[io.github.vigoo.zioaws.lexruntime.model.ConfirmationStatus] =
      scala
        .Option(impl.confirmationStatus())
        .map(value =>
          io.github.vigoo.zioaws.lexruntime.model.ConfirmationStatus.wrap(value)
        )
    override def dialogActionTypeValue
        : io.github.vigoo.zioaws.lexruntime.model.DialogActionType =
      io.github.vigoo.zioaws.lexruntime.model.DialogActionType
        .wrap(impl.dialogActionType())
    override def fulfillmentStateValue
        : Option[io.github.vigoo.zioaws.lexruntime.model.FulfillmentState] =
      scala
        .Option(impl.fulfillmentState())
        .map(value =>
          io.github.vigoo.zioaws.lexruntime.model.FulfillmentState.wrap(value)
        )
    override def slotToElicitValue: Option[String] =
      scala.Option(impl.slotToElicit()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntime.model.IntentSummary
  ): io.github.vigoo.zioaws.lexruntime.model.IntentSummary.ReadOnly =
    new Wrapper(impl)
}
