package io.github.vigoo.zioaws.lexruntime.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class IntentConfidence(score: Option[Double] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntime.model.IntentConfidence = {
    import IntentConfidence.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntime.model.IntentConfidence
      .builder()
      .optionallyWith(score.map(value => value: java.lang.Double))(_.score)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lexruntime.model.IntentConfidence.ReadOnly =
    io.github.vigoo.zioaws.lexruntime.model.IntentConfidence
      .wrap(buildAwsValue())
}
object IntentConfidence {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntime.model.IntentConfidence
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lexruntime.model.IntentConfidence =
      io.github.vigoo.zioaws.lexruntime.model
        .IntentConfidence(scoreValue.map(value => value))
    def scoreValue: Option[Double]
    def score: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("score", scoreValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lexruntime.model.IntentConfidence
  ) extends io.github.vigoo.zioaws.lexruntime.model.IntentConfidence.ReadOnly {
    override def scoreValue: Option[Double] =
      scala.Option(impl.score()).map(value => value: Double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntime.model.IntentConfidence
  ): io.github.vigoo.zioaws.lexruntime.model.IntentConfidence.ReadOnly =
    new Wrapper(impl)
}
