package io.github.vigoo.zioaws.lexruntime.model
import scala.jdk.CollectionConverters.*
sealed trait DialogActionType {
  def unwrap: software.amazon.awssdk.services.lexruntime.model.DialogActionType
}
object DialogActionType {
  def wrap(
      value: software.amazon.awssdk.services.lexruntime.model.DialogActionType
  ): io.github.vigoo.zioaws.lexruntime.model.DialogActionType = value match {
    case software.amazon.awssdk.services.lexruntime.model.DialogActionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lexruntime.model.DialogActionType.ELICIT_INTENT =>
      val r = ElicitIntent
      r
    case software.amazon.awssdk.services.lexruntime.model.DialogActionType.CONFIRM_INTENT =>
      val r = ConfirmIntent
      r
    case software.amazon.awssdk.services.lexruntime.model.DialogActionType.ELICIT_SLOT =>
      val r = ElicitSlot
      r
    case software.amazon.awssdk.services.lexruntime.model.DialogActionType.CLOSE =>
      val r = Close
      r
    case software.amazon.awssdk.services.lexruntime.model.DialogActionType.DELEGATE =>
      val r = Delegate
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.lexruntime.model.DialogActionType {
    override def unwrap
        : software.amazon.awssdk.services.lexruntime.model.DialogActionType =
      software.amazon.awssdk.services.lexruntime.model.DialogActionType.UNKNOWN_TO_SDK_VERSION
  }
  case object ElicitIntent
      extends io.github.vigoo.zioaws.lexruntime.model.DialogActionType {
    override def unwrap
        : software.amazon.awssdk.services.lexruntime.model.DialogActionType =
      software.amazon.awssdk.services.lexruntime.model.DialogActionType.ELICIT_INTENT
  }
  case object ConfirmIntent
      extends io.github.vigoo.zioaws.lexruntime.model.DialogActionType {
    override def unwrap
        : software.amazon.awssdk.services.lexruntime.model.DialogActionType =
      software.amazon.awssdk.services.lexruntime.model.DialogActionType.CONFIRM_INTENT
  }
  case object ElicitSlot
      extends io.github.vigoo.zioaws.lexruntime.model.DialogActionType {
    override def unwrap
        : software.amazon.awssdk.services.lexruntime.model.DialogActionType =
      software.amazon.awssdk.services.lexruntime.model.DialogActionType.ELICIT_SLOT
  }
  case object Close
      extends io.github.vigoo.zioaws.lexruntime.model.DialogActionType {
    override def unwrap
        : software.amazon.awssdk.services.lexruntime.model.DialogActionType =
      software.amazon.awssdk.services.lexruntime.model.DialogActionType.CLOSE
  }
  case object Delegate
      extends io.github.vigoo.zioaws.lexruntime.model.DialogActionType {
    override def unwrap
        : software.amazon.awssdk.services.lexruntime.model.DialogActionType =
      software.amazon.awssdk.services.lexruntime.model.DialogActionType.DELEGATE
  }
}
