package io.github.vigoo.zioaws.lexruntime.model
import io.github.vigoo.zioaws.lexruntime.model.primitives.{Text, IntentName}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DialogAction(
    `type`: io.github.vigoo.zioaws.lexruntime.model.DialogActionType,
    intentName: Option[IntentName] = None,
    slots: Option[Map[String, String]] = None,
    slotToElicit: Option[String] = None,
    fulfillmentState: Option[
      io.github.vigoo.zioaws.lexruntime.model.FulfillmentState
    ] = None,
    message: Option[Text] = None,
    messageFormat: Option[
      io.github.vigoo.zioaws.lexruntime.model.MessageFormatType
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntime.model.DialogAction = {
    import DialogAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntime.model.DialogAction
      .builder()
      .`type`(`type`.unwrap)
      .optionallyWith(intentName.map(value => value: java.lang.String))(
        _.intentName
      )
      .optionallyWith(
        slots.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.slots)
      .optionallyWith(slotToElicit.map(value => value: java.lang.String))(
        _.slotToElicit
      )
      .optionallyWith(fulfillmentState.map(value => value.unwrap))(
        _.fulfillmentState
      )
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .optionallyWith(messageFormat.map(value => value.unwrap))(_.messageFormat)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lexruntime.model.DialogAction.ReadOnly =
    io.github.vigoo.zioaws.lexruntime.model.DialogAction.wrap(buildAwsValue())
}
object DialogAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntime.model.DialogAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lexruntime.model.DialogAction =
      io.github.vigoo.zioaws.lexruntime.model.DialogAction(
        typeValue,
        intentNameValue.map(value => value),
        slotsValue.map(value => value),
        slotToElicitValue.map(value => value),
        fulfillmentStateValue.map(value => value),
        messageValue.map(value => value),
        messageFormatValue.map(value => value)
      )
    def typeValue: io.github.vigoo.zioaws.lexruntime.model.DialogActionType
    def intentNameValue: Option[IntentName]
    def slotsValue: Option[Map[String, String]]
    def slotToElicitValue: Option[String]
    def fulfillmentStateValue
        : Option[io.github.vigoo.zioaws.lexruntime.model.FulfillmentState]
    def messageValue: Option[Text]
    def messageFormatValue
        : Option[io.github.vigoo.zioaws.lexruntime.model.MessageFormatType]
    def `type`: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.lexruntime.model.DialogActionType
    ] = ZIO.succeed(typeValue)
    def intentName: ZIO[Any, AwsError, IntentName] =
      AwsError.unwrapOptionField("intentName", intentNameValue)
    def slots: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("slots", slotsValue)
    def slotToElicit: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("slotToElicit", slotToElicitValue)
    def fulfillmentState: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lexruntime.model.FulfillmentState
    ] = AwsError.unwrapOptionField("fulfillmentState", fulfillmentStateValue)
    def message: ZIO[Any, AwsError, Text] =
      AwsError.unwrapOptionField("message", messageValue)
    def messageFormat: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lexruntime.model.MessageFormatType
    ] = AwsError.unwrapOptionField("messageFormat", messageFormatValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lexruntime.model.DialogAction
  ) extends io.github.vigoo.zioaws.lexruntime.model.DialogAction.ReadOnly {
    override def typeValue
        : io.github.vigoo.zioaws.lexruntime.model.DialogActionType =
      io.github.vigoo.zioaws.lexruntime.model.DialogActionType
        .wrap(impl.`type`())
    override def intentNameValue: Option[IntentName] =
      scala.Option(impl.intentName()).map(value => value: IntentName)
    override def slotsValue: Option[Map[String, String]] = scala
      .Option(impl.slots())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override def slotToElicitValue: Option[String] =
      scala.Option(impl.slotToElicit()).map(value => value: String)
    override def fulfillmentStateValue
        : Option[io.github.vigoo.zioaws.lexruntime.model.FulfillmentState] =
      scala
        .Option(impl.fulfillmentState())
        .map(value =>
          io.github.vigoo.zioaws.lexruntime.model.FulfillmentState.wrap(value)
        )
    override def messageValue: Option[Text] =
      scala.Option(impl.message()).map(value => value: Text)
    override def messageFormatValue
        : Option[io.github.vigoo.zioaws.lexruntime.model.MessageFormatType] =
      scala
        .Option(impl.messageFormat())
        .map(value =>
          io.github.vigoo.zioaws.lexruntime.model.MessageFormatType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntime.model.DialogAction
  ): io.github.vigoo.zioaws.lexruntime.model.DialogAction.ReadOnly =
    new Wrapper(impl)
}
