package io.github.vigoo.zioaws.lexruntime.model
import io.github.vigoo.zioaws.lexruntime.model.primitives.{
  Text,
  ParameterName,
  ActiveContextName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ActiveContext(
    name: ActiveContextName,
    timeToLive: io.github.vigoo.zioaws.lexruntime.model.ActiveContextTimeToLive,
    parameters: Map[ParameterName, Text]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntime.model.ActiveContext = {
    import ActiveContext.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntime.model.ActiveContext
      .builder()
      .name(name: java.lang.String)
      .timeToLive(timeToLive.buildAwsValue())
      .parameters(
        parameters
          .map({ case (key, value) =>
            (key: java.lang.String) -> (value: java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lexruntime.model.ActiveContext.ReadOnly =
    io.github.vigoo.zioaws.lexruntime.model.ActiveContext.wrap(buildAwsValue())
}
object ActiveContext {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntime.model.ActiveContext
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lexruntime.model.ActiveContext =
      io.github.vigoo.zioaws.lexruntime.model
        .ActiveContext(nameValue, timeToLiveValue.editable, parametersValue)
    def nameValue: ActiveContextName
    def timeToLiveValue
        : io.github.vigoo.zioaws.lexruntime.model.ActiveContextTimeToLive.ReadOnly
    def parametersValue: Map[ParameterName, Text]
    def name: ZIO[Any, Nothing, ActiveContextName] = ZIO.succeed(nameValue)
    def timeToLive: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.lexruntime.model.ActiveContextTimeToLive.ReadOnly
    ] = ZIO.succeed(timeToLiveValue)
    def parameters: ZIO[Any, Nothing, Map[ParameterName, Text]] =
      ZIO.succeed(parametersValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lexruntime.model.ActiveContext
  ) extends io.github.vigoo.zioaws.lexruntime.model.ActiveContext.ReadOnly {
    override def nameValue: ActiveContextName = impl.name(): ActiveContextName
    override def timeToLiveValue
        : io.github.vigoo.zioaws.lexruntime.model.ActiveContextTimeToLive.ReadOnly =
      io.github.vigoo.zioaws.lexruntime.model.ActiveContextTimeToLive
        .wrap(impl.timeToLive())
    override def parametersValue: Map[ParameterName, Text] = impl
      .parameters()
      .asScala
      .map({ case (key, value) =>
        (key: ParameterName) -> (value: Text)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntime.model.ActiveContext
  ): io.github.vigoo.zioaws.lexruntime.model.ActiveContext.ReadOnly =
    new Wrapper(impl)
}
