package io.github.vigoo.zioaws.lexruntime.model
import io.github.vigoo.zioaws.lexruntime.model.primitives.{
  HttpContentType,
  UserId,
  Accept,
  BotAlias,
  AttributesString,
  ActiveContextsString,
  BotName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PostContentRequest(
    botName: BotName,
    botAlias: BotAlias,
    userId: UserId,
    sessionAttributes: Option[AttributesString] = None,
    requestAttributes: Option[AttributesString] = None,
    contentType: HttpContentType,
    accept: Option[Accept] = None,
    activeContexts: Option[ActiveContextsString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntime.model.PostContentRequest = {
    import PostContentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntime.model.PostContentRequest
      .builder()
      .botName(botName: java.lang.String)
      .botAlias(botAlias: java.lang.String)
      .userId(userId: java.lang.String)
      .optionallyWith(sessionAttributes.map(value => value: java.lang.String))(
        _.sessionAttributes
      )
      .optionallyWith(requestAttributes.map(value => value: java.lang.String))(
        _.requestAttributes
      )
      .contentType(contentType: java.lang.String)
      .optionallyWith(accept.map(value => value: java.lang.String))(_.accept)
      .optionallyWith(activeContexts.map(value => value: java.lang.String))(
        _.activeContexts
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lexruntime.model.PostContentRequest.ReadOnly =
    io.github.vigoo.zioaws.lexruntime.model.PostContentRequest
      .wrap(buildAwsValue())
}
object PostContentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntime.model.PostContentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lexruntime.model.PostContentRequest =
      io.github.vigoo.zioaws.lexruntime.model.PostContentRequest(
        botNameValue,
        botAliasValue,
        userIdValue,
        sessionAttributesValue.map(value => value),
        requestAttributesValue.map(value => value),
        contentTypeValue,
        acceptValue.map(value => value),
        activeContextsValue.map(value => value)
      )
    def botNameValue: BotName
    def botAliasValue: BotAlias
    def userIdValue: UserId
    def sessionAttributesValue: Option[AttributesString]
    def requestAttributesValue: Option[AttributesString]
    def contentTypeValue: HttpContentType
    def acceptValue: Option[Accept]
    def activeContextsValue: Option[ActiveContextsString]
    def botName: ZIO[Any, Nothing, BotName] = ZIO.succeed(botNameValue)
    def botAlias: ZIO[Any, Nothing, BotAlias] = ZIO.succeed(botAliasValue)
    def userId: ZIO[Any, Nothing, UserId] = ZIO.succeed(userIdValue)
    def sessionAttributes: ZIO[Any, AwsError, AttributesString] =
      AwsError.unwrapOptionField("sessionAttributes", sessionAttributesValue)
    def requestAttributes: ZIO[Any, AwsError, AttributesString] =
      AwsError.unwrapOptionField("requestAttributes", requestAttributesValue)
    def contentType: ZIO[Any, Nothing, HttpContentType] =
      ZIO.succeed(contentTypeValue)
    def accept: ZIO[Any, AwsError, Accept] =
      AwsError.unwrapOptionField("accept", acceptValue)
    def activeContexts: ZIO[Any, AwsError, ActiveContextsString] =
      AwsError.unwrapOptionField("activeContexts", activeContextsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lexruntime.model.PostContentRequest
  ) extends io.github.vigoo.zioaws.lexruntime.model.PostContentRequest.ReadOnly {
    override def botNameValue: BotName = impl.botName(): BotName
    override def botAliasValue: BotAlias = impl.botAlias(): BotAlias
    override def userIdValue: UserId = impl.userId(): UserId
    override def sessionAttributesValue: Option[AttributesString] = scala
      .Option(impl.sessionAttributes())
      .map(value => value: AttributesString)
    override def requestAttributesValue: Option[AttributesString] = scala
      .Option(impl.requestAttributes())
      .map(value => value: AttributesString)
    override def contentTypeValue: HttpContentType =
      impl.contentType(): HttpContentType
    override def acceptValue: Option[Accept] =
      scala.Option(impl.accept()).map(value => value: Accept)
    override def activeContextsValue: Option[ActiveContextsString] = scala
      .Option(impl.activeContexts())
      .map(value => value: ActiveContextsString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntime.model.PostContentRequest
  ): io.github.vigoo.zioaws.lexruntime.model.PostContentRequest.ReadOnly =
    new Wrapper(impl)
}
