package io.github.vigoo.zioaws.lexruntime.model
import io.github.vigoo.zioaws.lexruntime.model.primitives.{
  UserId,
  BotAlias,
  BotName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteSessionResponse(
    botName: Option[BotName] = None,
    botAlias: Option[BotAlias] = None,
    userId: Option[UserId] = None,
    sessionId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntime.model.DeleteSessionResponse = {
    import DeleteSessionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntime.model.DeleteSessionResponse
      .builder()
      .optionallyWith(botName.map(value => value: java.lang.String))(_.botName)
      .optionallyWith(botAlias.map(value => value: java.lang.String))(
        _.botAlias
      )
      .optionallyWith(userId.map(value => value: java.lang.String))(_.userId)
      .optionallyWith(sessionId.map(value => value: java.lang.String))(
        _.sessionId
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lexruntime.model.DeleteSessionResponse.ReadOnly =
    io.github.vigoo.zioaws.lexruntime.model.DeleteSessionResponse
      .wrap(buildAwsValue())
}
object DeleteSessionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntime.model.DeleteSessionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lexruntime.model.DeleteSessionResponse =
      io.github.vigoo.zioaws.lexruntime.model.DeleteSessionResponse(
        botNameValue.map(value => value),
        botAliasValue.map(value => value),
        userIdValue.map(value => value),
        sessionIdValue.map(value => value)
      )
    def botNameValue: Option[BotName]
    def botAliasValue: Option[BotAlias]
    def userIdValue: Option[UserId]
    def sessionIdValue: Option[String]
    def botName: ZIO[Any, AwsError, BotName] =
      AwsError.unwrapOptionField("botName", botNameValue)
    def botAlias: ZIO[Any, AwsError, BotAlias] =
      AwsError.unwrapOptionField("botAlias", botAliasValue)
    def userId: ZIO[Any, AwsError, UserId] =
      AwsError.unwrapOptionField("userId", userIdValue)
    def sessionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sessionId", sessionIdValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lexruntime.model.DeleteSessionResponse
  ) extends io.github.vigoo.zioaws.lexruntime.model.DeleteSessionResponse.ReadOnly {
    override def botNameValue: Option[BotName] =
      scala.Option(impl.botName()).map(value => value: BotName)
    override def botAliasValue: Option[BotAlias] =
      scala.Option(impl.botAlias()).map(value => value: BotAlias)
    override def userIdValue: Option[UserId] =
      scala.Option(impl.userId()).map(value => value: UserId)
    override def sessionIdValue: Option[String] =
      scala.Option(impl.sessionId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntime.model.DeleteSessionResponse
  ): io.github.vigoo.zioaws.lexruntime.model.DeleteSessionResponse.ReadOnly =
    new Wrapper(impl)
}
