package io.github.vigoo.zioaws.lexruntime.model
import io.github.vigoo.zioaws.lexruntime.model.primitives.{
  HttpContentType,
  Text,
  SensitiveStringUnbounded,
  IntentName,
  BotVersion,
  ActiveContextsString,
  SensitiveString
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PostContentResponse(
    contentType: Option[HttpContentType] = None,
    intentName: Option[IntentName] = None,
    nluIntentConfidence: Option[String] = None,
    alternativeIntents: Option[String] = None,
    slots: Option[String] = None,
    sessionAttributes: Option[String] = None,
    sentimentResponse: Option[String] = None,
    message: Option[Text] = None,
    encodedMessage: Option[SensitiveString] = None,
    messageFormat: Option[
      io.github.vigoo.zioaws.lexruntime.model.MessageFormatType
    ] = None,
    dialogState: Option[io.github.vigoo.zioaws.lexruntime.model.DialogState] =
      None,
    slotToElicit: Option[String] = None,
    inputTranscript: Option[String] = None,
    encodedInputTranscript: Option[SensitiveStringUnbounded] = None,
    botVersion: Option[BotVersion] = None,
    sessionId: Option[String] = None,
    activeContexts: Option[ActiveContextsString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntime.model.PostContentResponse = {
    import PostContentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntime.model.PostContentResponse
      .builder()
      .optionallyWith(contentType.map(value => value: java.lang.String))(
        _.contentType
      )
      .optionallyWith(intentName.map(value => value: java.lang.String))(
        _.intentName
      )
      .optionallyWith(
        nluIntentConfidence.map(value => value: java.lang.String)
      )(_.nluIntentConfidence)
      .optionallyWith(alternativeIntents.map(value => value: java.lang.String))(
        _.alternativeIntents
      )
      .optionallyWith(slots.map(value => value: java.lang.String))(_.slots)
      .optionallyWith(sessionAttributes.map(value => value: java.lang.String))(
        _.sessionAttributes
      )
      .optionallyWith(sentimentResponse.map(value => value: java.lang.String))(
        _.sentimentResponse
      )
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .optionallyWith(encodedMessage.map(value => value: java.lang.String))(
        _.encodedMessage
      )
      .optionallyWith(messageFormat.map(value => value.unwrap))(_.messageFormat)
      .optionallyWith(dialogState.map(value => value.unwrap))(_.dialogState)
      .optionallyWith(slotToElicit.map(value => value: java.lang.String))(
        _.slotToElicit
      )
      .optionallyWith(inputTranscript.map(value => value: java.lang.String))(
        _.inputTranscript
      )
      .optionallyWith(
        encodedInputTranscript.map(value => value: java.lang.String)
      )(_.encodedInputTranscript)
      .optionallyWith(botVersion.map(value => value: java.lang.String))(
        _.botVersion
      )
      .optionallyWith(sessionId.map(value => value: java.lang.String))(
        _.sessionId
      )
      .optionallyWith(activeContexts.map(value => value: java.lang.String))(
        _.activeContexts
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lexruntime.model.PostContentResponse.ReadOnly =
    io.github.vigoo.zioaws.lexruntime.model.PostContentResponse
      .wrap(buildAwsValue())
}
object PostContentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntime.model.PostContentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lexruntime.model.PostContentResponse =
      io.github.vigoo.zioaws.lexruntime.model.PostContentResponse(
        contentTypeValue.map(value => value),
        intentNameValue.map(value => value),
        nluIntentConfidenceValue.map(value => value),
        alternativeIntentsValue.map(value => value),
        slotsValue.map(value => value),
        sessionAttributesValue.map(value => value),
        sentimentResponseValue.map(value => value),
        messageValue.map(value => value),
        encodedMessageValue.map(value => value),
        messageFormatValue.map(value => value),
        dialogStateValue.map(value => value),
        slotToElicitValue.map(value => value),
        inputTranscriptValue.map(value => value),
        encodedInputTranscriptValue.map(value => value),
        botVersionValue.map(value => value),
        sessionIdValue.map(value => value),
        activeContextsValue.map(value => value)
      )
    def contentTypeValue: Option[HttpContentType]
    def intentNameValue: Option[IntentName]
    def nluIntentConfidenceValue: Option[String]
    def alternativeIntentsValue: Option[String]
    def slotsValue: Option[String]
    def sessionAttributesValue: Option[String]
    def sentimentResponseValue: Option[String]
    def messageValue: Option[Text]
    def encodedMessageValue: Option[SensitiveString]
    def messageFormatValue
        : Option[io.github.vigoo.zioaws.lexruntime.model.MessageFormatType]
    def dialogStateValue
        : Option[io.github.vigoo.zioaws.lexruntime.model.DialogState]
    def slotToElicitValue: Option[String]
    def inputTranscriptValue: Option[String]
    def encodedInputTranscriptValue: Option[SensitiveStringUnbounded]
    def botVersionValue: Option[BotVersion]
    def sessionIdValue: Option[String]
    def activeContextsValue: Option[ActiveContextsString]
    def contentType: ZIO[Any, AwsError, HttpContentType] =
      AwsError.unwrapOptionField("contentType", contentTypeValue)
    def intentName: ZIO[Any, AwsError, IntentName] =
      AwsError.unwrapOptionField("intentName", intentNameValue)
    def nluIntentConfidence: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("nluIntentConfidence", nluIntentConfidenceValue)
    def alternativeIntents: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("alternativeIntents", alternativeIntentsValue)
    def slots: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("slots", slotsValue)
    def sessionAttributes: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sessionAttributes", sessionAttributesValue)
    def sentimentResponse: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sentimentResponse", sentimentResponseValue)
    def message: ZIO[Any, AwsError, Text] =
      AwsError.unwrapOptionField("message", messageValue)
    def encodedMessage: ZIO[Any, AwsError, SensitiveString] =
      AwsError.unwrapOptionField("encodedMessage", encodedMessageValue)
    def messageFormat: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lexruntime.model.MessageFormatType
    ] = AwsError.unwrapOptionField("messageFormat", messageFormatValue)
    def dialogState: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lexruntime.model.DialogState
    ] = AwsError.unwrapOptionField("dialogState", dialogStateValue)
    def slotToElicit: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("slotToElicit", slotToElicitValue)
    def inputTranscript: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("inputTranscript", inputTranscriptValue)
    def encodedInputTranscript: ZIO[Any, AwsError, SensitiveStringUnbounded] =
      AwsError.unwrapOptionField(
        "encodedInputTranscript",
        encodedInputTranscriptValue
      )
    def botVersion: ZIO[Any, AwsError, BotVersion] =
      AwsError.unwrapOptionField("botVersion", botVersionValue)
    def sessionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sessionId", sessionIdValue)
    def activeContexts: ZIO[Any, AwsError, ActiveContextsString] =
      AwsError.unwrapOptionField("activeContexts", activeContextsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lexruntime.model.PostContentResponse
  ) extends io.github.vigoo.zioaws.lexruntime.model.PostContentResponse.ReadOnly {
    override def contentTypeValue: Option[HttpContentType] =
      scala.Option(impl.contentType()).map(value => value: HttpContentType)
    override def intentNameValue: Option[IntentName] =
      scala.Option(impl.intentName()).map(value => value: IntentName)
    override def nluIntentConfidenceValue: Option[String] =
      scala.Option(impl.nluIntentConfidence()).map(value => value: String)
    override def alternativeIntentsValue: Option[String] =
      scala.Option(impl.alternativeIntents()).map(value => value: String)
    override def slotsValue: Option[String] =
      scala.Option(impl.slots()).map(value => value: String)
    override def sessionAttributesValue: Option[String] =
      scala.Option(impl.sessionAttributes()).map(value => value: String)
    override def sentimentResponseValue: Option[String] =
      scala.Option(impl.sentimentResponse()).map(value => value: String)
    override def messageValue: Option[Text] =
      scala.Option(impl.message()).map(value => value: Text)
    override def encodedMessageValue: Option[SensitiveString] =
      scala.Option(impl.encodedMessage()).map(value => value: SensitiveString)
    override def messageFormatValue
        : Option[io.github.vigoo.zioaws.lexruntime.model.MessageFormatType] =
      scala
        .Option(impl.messageFormat())
        .map(value =>
          io.github.vigoo.zioaws.lexruntime.model.MessageFormatType.wrap(value)
        )
    override def dialogStateValue
        : Option[io.github.vigoo.zioaws.lexruntime.model.DialogState] = scala
      .Option(impl.dialogState())
      .map(value =>
        io.github.vigoo.zioaws.lexruntime.model.DialogState.wrap(value)
      )
    override def slotToElicitValue: Option[String] =
      scala.Option(impl.slotToElicit()).map(value => value: String)
    override def inputTranscriptValue: Option[String] =
      scala.Option(impl.inputTranscript()).map(value => value: String)
    override def encodedInputTranscriptValue: Option[SensitiveStringUnbounded] =
      scala
        .Option(impl.encodedInputTranscript())
        .map(value => value: SensitiveStringUnbounded)
    override def botVersionValue: Option[BotVersion] =
      scala.Option(impl.botVersion()).map(value => value: BotVersion)
    override def sessionIdValue: Option[String] =
      scala.Option(impl.sessionId()).map(value => value: String)
    override def activeContextsValue: Option[ActiveContextsString] = scala
      .Option(impl.activeContexts())
      .map(value => value: ActiveContextsString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntime.model.PostContentResponse
  ): io.github.vigoo.zioaws.lexruntime.model.PostContentResponse.ReadOnly =
    new Wrapper(impl)
}
