package io.github.vigoo.zioaws.lexruntime.model
import scala.jdk.CollectionConverters.*
sealed trait ConfirmationStatus {
  def unwrap
      : software.amazon.awssdk.services.lexruntime.model.ConfirmationStatus
}
object ConfirmationStatus {
  def wrap(
      value: software.amazon.awssdk.services.lexruntime.model.ConfirmationStatus
  ): io.github.vigoo.zioaws.lexruntime.model.ConfirmationStatus = value match {
    case software.amazon.awssdk.services.lexruntime.model.ConfirmationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lexruntime.model.ConfirmationStatus.NONE =>
      val r = None
      r
    case software.amazon.awssdk.services.lexruntime.model.ConfirmationStatus.CONFIRMED =>
      val r = Confirmed
      r
    case software.amazon.awssdk.services.lexruntime.model.ConfirmationStatus.DENIED =>
      val r = Denied
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.lexruntime.model.ConfirmationStatus {
    override def unwrap
        : software.amazon.awssdk.services.lexruntime.model.ConfirmationStatus =
      software.amazon.awssdk.services.lexruntime.model.ConfirmationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object None
      extends io.github.vigoo.zioaws.lexruntime.model.ConfirmationStatus {
    override def unwrap
        : software.amazon.awssdk.services.lexruntime.model.ConfirmationStatus =
      software.amazon.awssdk.services.lexruntime.model.ConfirmationStatus.NONE
  }
  case object Confirmed
      extends io.github.vigoo.zioaws.lexruntime.model.ConfirmationStatus {
    override def unwrap
        : software.amazon.awssdk.services.lexruntime.model.ConfirmationStatus =
      software.amazon.awssdk.services.lexruntime.model.ConfirmationStatus.CONFIRMED
  }
  case object Denied
      extends io.github.vigoo.zioaws.lexruntime.model.ConfirmationStatus {
    override def unwrap
        : software.amazon.awssdk.services.lexruntime.model.ConfirmationStatus =
      software.amazon.awssdk.services.lexruntime.model.ConfirmationStatus.DENIED
  }
}
