package io.github.vigoo.zioaws.lexruntime.model
import io.github.vigoo.zioaws.lexruntime.model.primitives.{
  Text,
  UserId,
  BotAlias,
  BotName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PostTextRequest(
    botName: BotName,
    botAlias: BotAlias,
    userId: UserId,
    sessionAttributes: Option[Map[String, String]] = None,
    requestAttributes: Option[Map[String, String]] = None,
    inputText: Text,
    activeContexts: Option[
      Iterable[io.github.vigoo.zioaws.lexruntime.model.ActiveContext]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntime.model.PostTextRequest = {
    import PostTextRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntime.model.PostTextRequest
      .builder()
      .botName(botName: java.lang.String)
      .botAlias(botAlias: java.lang.String)
      .userId(userId: java.lang.String)
      .optionallyWith(
        sessionAttributes.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.sessionAttributes)
      .optionallyWith(
        requestAttributes.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.requestAttributes)
      .inputText(inputText: java.lang.String)
      .optionallyWith(
        activeContexts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.activeContexts)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lexruntime.model.PostTextRequest.ReadOnly =
    io.github.vigoo.zioaws.lexruntime.model.PostTextRequest
      .wrap(buildAwsValue())
}
object PostTextRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntime.model.PostTextRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lexruntime.model.PostTextRequest =
      io.github.vigoo.zioaws.lexruntime.model.PostTextRequest(
        botNameValue,
        botAliasValue,
        userIdValue,
        sessionAttributesValue.map(value => value),
        requestAttributesValue.map(value => value),
        inputTextValue,
        activeContextsValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def botNameValue: BotName
    def botAliasValue: BotAlias
    def userIdValue: UserId
    def sessionAttributesValue: Option[Map[String, String]]
    def requestAttributesValue: Option[Map[String, String]]
    def inputTextValue: Text
    def activeContextsValue: Option[
      List[io.github.vigoo.zioaws.lexruntime.model.ActiveContext.ReadOnly]
    ]
    def botName: ZIO[Any, Nothing, BotName] = ZIO.succeed(botNameValue)
    def botAlias: ZIO[Any, Nothing, BotAlias] = ZIO.succeed(botAliasValue)
    def userId: ZIO[Any, Nothing, UserId] = ZIO.succeed(userIdValue)
    def sessionAttributes: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("sessionAttributes", sessionAttributesValue)
    def requestAttributes: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("requestAttributes", requestAttributesValue)
    def inputText: ZIO[Any, Nothing, Text] = ZIO.succeed(inputTextValue)
    def activeContexts: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lexruntime.model.ActiveContext.ReadOnly
    ]] = AwsError.unwrapOptionField("activeContexts", activeContextsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lexruntime.model.PostTextRequest
  ) extends io.github.vigoo.zioaws.lexruntime.model.PostTextRequest.ReadOnly {
    override def botNameValue: BotName = impl.botName(): BotName
    override def botAliasValue: BotAlias = impl.botAlias(): BotAlias
    override def userIdValue: UserId = impl.userId(): UserId
    override def sessionAttributesValue: Option[Map[String, String]] = scala
      .Option(impl.sessionAttributes())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override def requestAttributesValue: Option[Map[String, String]] = scala
      .Option(impl.requestAttributes())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override def inputTextValue: Text = impl.inputText(): Text
    override def activeContextsValue: Option[
      List[io.github.vigoo.zioaws.lexruntime.model.ActiveContext.ReadOnly]
    ] = scala
      .Option(impl.activeContexts())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lexruntime.model.ActiveContext.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntime.model.PostTextRequest
  ): io.github.vigoo.zioaws.lexruntime.model.PostTextRequest.ReadOnly =
    new Wrapper(impl)
}
