package io.github.vigoo.zioaws.lexruntime.model
import io.github.vigoo.zioaws.lexruntime.model.primitives.{
  StringUrlWithLength,
  StringWithLength
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GenericAttachment(
    title: Option[StringWithLength] = None,
    subTitle: Option[StringWithLength] = None,
    attachmentLinkUrl: Option[StringUrlWithLength] = None,
    imageUrl: Option[StringUrlWithLength] = None,
    buttons: Option[Iterable[io.github.vigoo.zioaws.lexruntime.model.Button]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntime.model.GenericAttachment = {
    import GenericAttachment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntime.model.GenericAttachment
      .builder()
      .optionallyWith(title.map(value => value: java.lang.String))(_.title)
      .optionallyWith(subTitle.map(value => value: java.lang.String))(
        _.subTitle
      )
      .optionallyWith(attachmentLinkUrl.map(value => value: java.lang.String))(
        _.attachmentLinkUrl
      )
      .optionallyWith(imageUrl.map(value => value: java.lang.String))(
        _.imageUrl
      )
      .optionallyWith(
        buttons.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.buttons)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lexruntime.model.GenericAttachment.ReadOnly =
    io.github.vigoo.zioaws.lexruntime.model.GenericAttachment
      .wrap(buildAwsValue())
}
object GenericAttachment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntime.model.GenericAttachment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lexruntime.model.GenericAttachment =
      io.github.vigoo.zioaws.lexruntime.model.GenericAttachment(
        titleValue.map(value => value),
        subTitleValue.map(value => value),
        attachmentLinkUrlValue.map(value => value),
        imageUrlValue.map(value => value),
        buttonsValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def titleValue: Option[StringWithLength]
    def subTitleValue: Option[StringWithLength]
    def attachmentLinkUrlValue: Option[StringUrlWithLength]
    def imageUrlValue: Option[StringUrlWithLength]
    def buttonsValue
        : Option[List[io.github.vigoo.zioaws.lexruntime.model.Button.ReadOnly]]
    def title: ZIO[Any, AwsError, StringWithLength] =
      AwsError.unwrapOptionField("title", titleValue)
    def subTitle: ZIO[Any, AwsError, StringWithLength] =
      AwsError.unwrapOptionField("subTitle", subTitleValue)
    def attachmentLinkUrl: ZIO[Any, AwsError, StringUrlWithLength] =
      AwsError.unwrapOptionField("attachmentLinkUrl", attachmentLinkUrlValue)
    def imageUrl: ZIO[Any, AwsError, StringUrlWithLength] =
      AwsError.unwrapOptionField("imageUrl", imageUrlValue)
    def buttons: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lexruntime.model.Button.ReadOnly
    ]] = AwsError.unwrapOptionField("buttons", buttonsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lexruntime.model.GenericAttachment
  ) extends io.github.vigoo.zioaws.lexruntime.model.GenericAttachment.ReadOnly {
    override def titleValue: Option[StringWithLength] =
      scala.Option(impl.title()).map(value => value: StringWithLength)
    override def subTitleValue: Option[StringWithLength] =
      scala.Option(impl.subTitle()).map(value => value: StringWithLength)
    override def attachmentLinkUrlValue: Option[StringUrlWithLength] = scala
      .Option(impl.attachmentLinkUrl())
      .map(value => value: StringUrlWithLength)
    override def imageUrlValue: Option[StringUrlWithLength] =
      scala.Option(impl.imageUrl()).map(value => value: StringUrlWithLength)
    override def buttonsValue: Option[
      List[io.github.vigoo.zioaws.lexruntime.model.Button.ReadOnly]
    ] = scala
      .Option(impl.buttons())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lexruntime.model.Button.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntime.model.GenericAttachment
  ): io.github.vigoo.zioaws.lexruntime.model.GenericAttachment.ReadOnly =
    new Wrapper(impl)
}
