package io.github.vigoo.zioaws.lexruntime.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetSessionResponse(
    recentIntentSummaryView: Option[
      Iterable[io.github.vigoo.zioaws.lexruntime.model.IntentSummary]
    ] = None,
    sessionAttributes: Option[Map[String, String]] = None,
    sessionId: Option[String] = None,
    dialogAction: Option[io.github.vigoo.zioaws.lexruntime.model.DialogAction] =
      None,
    activeContexts: Option[
      Iterable[io.github.vigoo.zioaws.lexruntime.model.ActiveContext]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntime.model.GetSessionResponse = {
    import GetSessionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntime.model.GetSessionResponse
      .builder()
      .optionallyWith(
        recentIntentSummaryView.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recentIntentSummaryView)
      .optionallyWith(
        sessionAttributes.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.sessionAttributes)
      .optionallyWith(sessionId.map(value => value: java.lang.String))(
        _.sessionId
      )
      .optionallyWith(dialogAction.map(value => value.buildAwsValue()))(
        _.dialogAction
      )
      .optionallyWith(
        activeContexts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.activeContexts)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lexruntime.model.GetSessionResponse.ReadOnly =
    io.github.vigoo.zioaws.lexruntime.model.GetSessionResponse
      .wrap(buildAwsValue())
}
object GetSessionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntime.model.GetSessionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lexruntime.model.GetSessionResponse =
      io.github.vigoo.zioaws.lexruntime.model.GetSessionResponse(
        recentIntentSummaryViewValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        sessionAttributesValue.map(value => value),
        sessionIdValue.map(value => value),
        dialogActionValue.map(value => value.editable),
        activeContextsValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def recentIntentSummaryViewValue: Option[
      List[io.github.vigoo.zioaws.lexruntime.model.IntentSummary.ReadOnly]
    ]
    def sessionAttributesValue: Option[Map[String, String]]
    def sessionIdValue: Option[String]
    def dialogActionValue
        : Option[io.github.vigoo.zioaws.lexruntime.model.DialogAction.ReadOnly]
    def activeContextsValue: Option[
      List[io.github.vigoo.zioaws.lexruntime.model.ActiveContext.ReadOnly]
    ]
    def recentIntentSummaryView: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lexruntime.model.IntentSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "recentIntentSummaryView",
      recentIntentSummaryViewValue
    )
    def sessionAttributes: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("sessionAttributes", sessionAttributesValue)
    def sessionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sessionId", sessionIdValue)
    def dialogAction: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lexruntime.model.DialogAction.ReadOnly
    ] = AwsError.unwrapOptionField("dialogAction", dialogActionValue)
    def activeContexts: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lexruntime.model.ActiveContext.ReadOnly
    ]] = AwsError.unwrapOptionField("activeContexts", activeContextsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lexruntime.model.GetSessionResponse
  ) extends io.github.vigoo.zioaws.lexruntime.model.GetSessionResponse.ReadOnly {
    override def recentIntentSummaryViewValue: Option[
      List[io.github.vigoo.zioaws.lexruntime.model.IntentSummary.ReadOnly]
    ] = scala
      .Option(impl.recentIntentSummaryView())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lexruntime.model.IntentSummary.wrap(item)
        }.toList
      )
    override def sessionAttributesValue: Option[Map[String, String]] = scala
      .Option(impl.sessionAttributes())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override def sessionIdValue: Option[String] =
      scala.Option(impl.sessionId()).map(value => value: String)
    override def dialogActionValue: Option[
      io.github.vigoo.zioaws.lexruntime.model.DialogAction.ReadOnly
    ] = scala
      .Option(impl.dialogAction())
      .map(value =>
        io.github.vigoo.zioaws.lexruntime.model.DialogAction.wrap(value)
      )
    override def activeContextsValue: Option[
      List[io.github.vigoo.zioaws.lexruntime.model.ActiveContext.ReadOnly]
    ] = scala
      .Option(impl.activeContexts())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lexruntime.model.ActiveContext.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntime.model.GetSessionResponse
  ): io.github.vigoo.zioaws.lexruntime.model.GetSessionResponse.ReadOnly =
    new Wrapper(impl)
}
