package io.github.vigoo.zioaws.lexruntime.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class PutSessionRequest(botName: primitives.BotName, botAlias: primitives.BotAlias, userId: primitives.UserId, sessionAttributes: scala.Option[Map[String, String]] = None, dialogAction: scala.Option[DialogAction] = None, recentIntentSummaryView: scala.Option[Iterable[IntentSummary]] = None, accept: scala.Option[primitives.Accept] = None, activeContexts: scala.Option[Iterable[ActiveContext]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lexruntime.model.PutSessionRequest = {
    import PutSessionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntime.model.PutSessionRequest.builder().botName(botName: java.lang.String).botAlias(botAlias: java.lang.String).userId(userId: java.lang.String).optionallyWith(sessionAttributes.map(value => value.map({
      case (key, value) =>
        (key: java.lang.String) -> (value: java.lang.String)
    }).asJava))(_.sessionAttributes).optionallyWith(dialogAction.map(value => value.buildAwsValue()))(_.dialogAction).optionallyWith(recentIntentSummaryView.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.recentIntentSummaryView).optionallyWith(accept.map(value => value: java.lang.String))(_.accept).optionallyWith(activeContexts.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.activeContexts).build()
  }
  def asReadOnly: PutSessionRequest.ReadOnly = PutSessionRequest.wrap(buildAwsValue())
}
object PutSessionRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lexruntime.model.PutSessionRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: PutSessionRequest = PutSessionRequest(botNameValue, botAliasValue, userIdValue, sessionAttributesValue.map(value => value), dialogActionValue.map(value => value.editable), recentIntentSummaryViewValue.map(value => value.map { item => 
      item.editable
    }), acceptValue.map(value => value), activeContextsValue.map(value => value.map { item => 
      item.editable
    }))
    def botNameValue: primitives.BotName
    def botAliasValue: primitives.BotAlias
    def userIdValue: primitives.UserId
    def sessionAttributesValue: scala.Option[Map[String, String]]
    def dialogActionValue: scala.Option[DialogAction.ReadOnly]
    def recentIntentSummaryViewValue: scala.Option[List[IntentSummary.ReadOnly]]
    def acceptValue: scala.Option[primitives.Accept]
    def activeContextsValue: scala.Option[List[ActiveContext.ReadOnly]]
    def botName: ZIO[Any, Nothing, primitives.BotName] = ZIO.succeed(botNameValue)
    def botAlias: ZIO[Any, Nothing, primitives.BotAlias] = ZIO.succeed(botAliasValue)
    def userId: ZIO[Any, Nothing, primitives.UserId] = ZIO.succeed(userIdValue)
    def sessionAttributes: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Map[String, String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sessionAttributes", sessionAttributesValue)
    def dialogAction: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DialogAction.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dialogAction", dialogActionValue)
    def recentIntentSummaryView: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[IntentSummary.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("recentIntentSummaryView", recentIntentSummaryViewValue)
    def accept: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Accept] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("accept", acceptValue)
    def activeContexts: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[ActiveContext.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("activeContexts", activeContextsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lexruntime.model.PutSessionRequest) extends PutSessionRequest.ReadOnly {
    override def botNameValue: primitives.BotName = impl.botName(): primitives.BotName
    override def botAliasValue: primitives.BotAlias = impl.botAlias(): primitives.BotAlias
    override def userIdValue: primitives.UserId = impl.userId(): primitives.UserId
    override def sessionAttributesValue: scala.Option[Map[String, String]] = scala.Option(impl.sessionAttributes()).map(value => value.asScala.map({
      case (key, value) =>
        (key: String) -> (value: String)
    }).toMap)
    override def dialogActionValue: scala.Option[DialogAction.ReadOnly] = scala.Option(impl.dialogAction()).map(value => DialogAction.wrap(value))
    override def recentIntentSummaryViewValue: scala.Option[List[IntentSummary.ReadOnly]] = scala.Option(impl.recentIntentSummaryView()).map(value => value.asScala.map { item => 
      IntentSummary.wrap(item)
    }.toList)
    override def acceptValue: scala.Option[primitives.Accept] = scala.Option(impl.accept()).map(value => value: primitives.Accept)
    override def activeContextsValue: scala.Option[List[ActiveContext.ReadOnly]] = scala.Option(impl.activeContexts()).map(value => value.asScala.map { item => 
      ActiveContext.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.lexruntime.model.PutSessionRequest): ReadOnly = new Wrapper(impl)
}