package io.github.vigoo.zioaws.lexruntime.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class IntentConfidence(score: scala.Option[Double] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lexruntime.model.IntentConfidence = {
    import IntentConfidence.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntime.model.IntentConfidence.builder().optionallyWith(score.map(value => value: java.lang.Double))(_.score).build()
  }
  def asReadOnly: IntentConfidence.ReadOnly = IntentConfidence.wrap(buildAwsValue())
}
object IntentConfidence {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lexruntime.model.IntentConfidence] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: IntentConfidence = IntentConfidence(scoreValue.map(value => value))
    def scoreValue: scala.Option[Double]
    def score: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Double] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("score", scoreValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lexruntime.model.IntentConfidence) extends IntentConfidence.ReadOnly { override def scoreValue: scala.Option[Double] = scala.Option(impl.score()).map(value => value: Double) }
  def wrap(impl: software.amazon.awssdk.services.lexruntime.model.IntentConfidence): ReadOnly = new Wrapper(impl)
}