package io.github.vigoo.zioaws.lexruntime.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class Button(text: primitives.ButtonTextStringWithLength, value: primitives.ButtonValueStringWithLength) {
  def buildAwsValue(): software.amazon.awssdk.services.lexruntime.model.Button = {
    import Button.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntime.model.Button.builder().text(text: java.lang.String).value(value: java.lang.String).build()
  }
  def asReadOnly: Button.ReadOnly = Button.wrap(buildAwsValue())
}
object Button {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lexruntime.model.Button] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: Button = Button(textValue, valueValue)
    def textValue: primitives.ButtonTextStringWithLength
    def valueValue: primitives.ButtonValueStringWithLength
    def text: ZIO[Any, Nothing, primitives.ButtonTextStringWithLength] = ZIO.succeed(textValue)
    def value: ZIO[Any, Nothing, primitives.ButtonValueStringWithLength] = ZIO.succeed(valueValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lexruntime.model.Button) extends Button.ReadOnly {
    override def textValue: primitives.ButtonTextStringWithLength = impl.text(): primitives.ButtonTextStringWithLength
    override def valueValue: primitives.ButtonValueStringWithLength = impl.value(): primitives.ButtonValueStringWithLength
  }
  def wrap(impl: software.amazon.awssdk.services.lexruntime.model.Button): ReadOnly = new Wrapper(impl)
}