package io.github.vigoo.zioaws.lexruntime.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class PostContentResponse(contentType: scala.Option[primitives.HttpContentType] = None, intentName: scala.Option[primitives.IntentName] = None, nluIntentConfidence: scala.Option[String] = None, alternativeIntents: scala.Option[String] = None, slots: scala.Option[String] = None, sessionAttributes: scala.Option[String] = None, sentimentResponse: scala.Option[String] = None, message: scala.Option[primitives.Text] = None, encodedMessage: scala.Option[primitives.SensitiveString] = None, messageFormat: scala.Option[MessageFormatType] = None, dialogState: scala.Option[DialogState] = None, slotToElicit: scala.Option[String] = None, inputTranscript: scala.Option[String] = None, encodedInputTranscript: scala.Option[primitives.SensitiveStringUnbounded] = None, botVersion: scala.Option[primitives.BotVersion] = None, sessionId: scala.Option[String] = None, activeContexts: scala.Option[primitives.ActiveContextsString] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lexruntime.model.PostContentResponse = {
    import PostContentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntime.model.PostContentResponse.builder().optionallyWith(contentType.map(value => value: java.lang.String))(_.contentType).optionallyWith(intentName.map(value => value: java.lang.String))(_.intentName).optionallyWith(nluIntentConfidence.map(value => value: java.lang.String))(_.nluIntentConfidence).optionallyWith(alternativeIntents.map(value => value: java.lang.String))(_.alternativeIntents).optionallyWith(slots.map(value => value: java.lang.String))(_.slots).optionallyWith(sessionAttributes.map(value => value: java.lang.String))(_.sessionAttributes).optionallyWith(sentimentResponse.map(value => value: java.lang.String))(_.sentimentResponse).optionallyWith(message.map(value => value: java.lang.String))(_.message).optionallyWith(encodedMessage.map(value => value: java.lang.String))(_.encodedMessage).optionallyWith(messageFormat.map(value => value.unwrap))(_.messageFormat).optionallyWith(dialogState.map(value => value.unwrap))(_.dialogState).optionallyWith(slotToElicit.map(value => value: java.lang.String))(_.slotToElicit).optionallyWith(inputTranscript.map(value => value: java.lang.String))(_.inputTranscript).optionallyWith(encodedInputTranscript.map(value => value: java.lang.String))(_.encodedInputTranscript).optionallyWith(botVersion.map(value => value: java.lang.String))(_.botVersion).optionallyWith(sessionId.map(value => value: java.lang.String))(_.sessionId).optionallyWith(activeContexts.map(value => value: java.lang.String))(_.activeContexts).build()
  }
  def asReadOnly: PostContentResponse.ReadOnly = PostContentResponse.wrap(buildAwsValue())
}
object PostContentResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lexruntime.model.PostContentResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: PostContentResponse = PostContentResponse(contentTypeValue.map(value => value), intentNameValue.map(value => value), nluIntentConfidenceValue.map(value => value), alternativeIntentsValue.map(value => value), slotsValue.map(value => value), sessionAttributesValue.map(value => value), sentimentResponseValue.map(value => value), messageValue.map(value => value), encodedMessageValue.map(value => value), messageFormatValue.map(value => value), dialogStateValue.map(value => value), slotToElicitValue.map(value => value), inputTranscriptValue.map(value => value), encodedInputTranscriptValue.map(value => value), botVersionValue.map(value => value), sessionIdValue.map(value => value), activeContextsValue.map(value => value))
    def contentTypeValue: scala.Option[primitives.HttpContentType]
    def intentNameValue: scala.Option[primitives.IntentName]
    def nluIntentConfidenceValue: scala.Option[String]
    def alternativeIntentsValue: scala.Option[String]
    def slotsValue: scala.Option[String]
    def sessionAttributesValue: scala.Option[String]
    def sentimentResponseValue: scala.Option[String]
    def messageValue: scala.Option[primitives.Text]
    def encodedMessageValue: scala.Option[primitives.SensitiveString]
    def messageFormatValue: scala.Option[MessageFormatType]
    def dialogStateValue: scala.Option[DialogState]
    def slotToElicitValue: scala.Option[String]
    def inputTranscriptValue: scala.Option[String]
    def encodedInputTranscriptValue: scala.Option[primitives.SensitiveStringUnbounded]
    def botVersionValue: scala.Option[primitives.BotVersion]
    def sessionIdValue: scala.Option[String]
    def activeContextsValue: scala.Option[primitives.ActiveContextsString]
    def contentType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.HttpContentType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("contentType", contentTypeValue)
    def intentName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntentName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("intentName", intentNameValue)
    def nluIntentConfidence: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nluIntentConfidence", nluIntentConfidenceValue)
    def alternativeIntents: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("alternativeIntents", alternativeIntentsValue)
    def slots: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("slots", slotsValue)
    def sessionAttributes: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sessionAttributes", sessionAttributesValue)
    def sentimentResponse: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sentimentResponse", sentimentResponseValue)
    def message: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Text] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("message", messageValue)
    def encodedMessage: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.SensitiveString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("encodedMessage", encodedMessageValue)
    def messageFormat: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, MessageFormatType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("messageFormat", messageFormatValue)
    def dialogState: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DialogState] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dialogState", dialogStateValue)
    def slotToElicit: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("slotToElicit", slotToElicitValue)
    def inputTranscript: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("inputTranscript", inputTranscriptValue)
    def encodedInputTranscript: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.SensitiveStringUnbounded] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("encodedInputTranscript", encodedInputTranscriptValue)
    def botVersion: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BotVersion] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("botVersion", botVersionValue)
    def sessionId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sessionId", sessionIdValue)
    def activeContexts: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ActiveContextsString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("activeContexts", activeContextsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lexruntime.model.PostContentResponse) extends PostContentResponse.ReadOnly {
    override def contentTypeValue: scala.Option[primitives.HttpContentType] = scala.Option(impl.contentType()).map(value => value: primitives.HttpContentType)
    override def intentNameValue: scala.Option[primitives.IntentName] = scala.Option(impl.intentName()).map(value => value: primitives.IntentName)
    override def nluIntentConfidenceValue: scala.Option[String] = scala.Option(impl.nluIntentConfidence()).map(value => value: String)
    override def alternativeIntentsValue: scala.Option[String] = scala.Option(impl.alternativeIntents()).map(value => value: String)
    override def slotsValue: scala.Option[String] = scala.Option(impl.slots()).map(value => value: String)
    override def sessionAttributesValue: scala.Option[String] = scala.Option(impl.sessionAttributes()).map(value => value: String)
    override def sentimentResponseValue: scala.Option[String] = scala.Option(impl.sentimentResponse()).map(value => value: String)
    override def messageValue: scala.Option[primitives.Text] = scala.Option(impl.message()).map(value => value: primitives.Text)
    override def encodedMessageValue: scala.Option[primitives.SensitiveString] = scala.Option(impl.encodedMessage()).map(value => value: primitives.SensitiveString)
    override def messageFormatValue: scala.Option[MessageFormatType] = scala.Option(impl.messageFormat()).map(value => MessageFormatType.wrap(value))
    override def dialogStateValue: scala.Option[DialogState] = scala.Option(impl.dialogState()).map(value => DialogState.wrap(value))
    override def slotToElicitValue: scala.Option[String] = scala.Option(impl.slotToElicit()).map(value => value: String)
    override def inputTranscriptValue: scala.Option[String] = scala.Option(impl.inputTranscript()).map(value => value: String)
    override def encodedInputTranscriptValue: scala.Option[primitives.SensitiveStringUnbounded] = scala.Option(impl.encodedInputTranscript()).map(value => value: primitives.SensitiveStringUnbounded)
    override def botVersionValue: scala.Option[primitives.BotVersion] = scala.Option(impl.botVersion()).map(value => value: primitives.BotVersion)
    override def sessionIdValue: scala.Option[String] = scala.Option(impl.sessionId()).map(value => value: String)
    override def activeContextsValue: scala.Option[primitives.ActiveContextsString] = scala.Option(impl.activeContexts()).map(value => value: primitives.ActiveContextsString)
  }
  def wrap(impl: software.amazon.awssdk.services.lexruntime.model.PostContentResponse): ReadOnly = new Wrapper(impl)
}