package io.github.vigoo.zioaws.lexruntime
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
package object model {
  object primitives {
    type Accept = String
    type ActiveContextName = String
    type ActiveContextTimeToLiveInSeconds = Int
    type ActiveContextTurnsToLive = Int
    type ActiveContextsString = String
    type AttributesString = String
    type BlobStream = Chunk[Byte]
    type BotAlias = String
    type BotName = String
    type BotVersion = String
    type ButtonTextStringWithLength = String
    type ButtonValueStringWithLength = String
    type HttpContentType = String
    type IntentName = String
    type IntentSummaryCheckpointLabel = String
    type ParameterName = String
    type SensitiveString = String
    type SensitiveStringUnbounded = String
    type SentimentLabel = String
    type SentimentScore = String
    type StringUrlWithLength = String
    type StringWithLength = String
    type Text = String
    type UserId = String
  }
  type ActiveContextParametersMap = Map[primitives.ParameterName, primitives.Text]
  type ActiveContextsList = List[ActiveContext]
  type GenericAttachmentList = List[GenericAttachment]
  type IntentList = List[PredictedIntent]
  type IntentSummaryList = List[IntentSummary]
  type ListOfButtons = List[Button]
  type StringMap = Map[String, String]
}