package io.github.vigoo.zioaws.lexruntime.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class PostTextRequest(botName: primitives.BotName, botAlias: primitives.BotAlias, userId: primitives.UserId, sessionAttributes: scala.Option[Map[String, String]] = None, requestAttributes: scala.Option[Map[String, String]] = None, inputText: primitives.Text, activeContexts: scala.Option[Iterable[ActiveContext]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lexruntime.model.PostTextRequest = {
    import PostTextRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntime.model.PostTextRequest.builder().botName(botName: java.lang.String).botAlias(botAlias: java.lang.String).userId(userId: java.lang.String).optionallyWith(sessionAttributes.map(value => value.map({
      case (key, value) =>
        (key: java.lang.String) -> (value: java.lang.String)
    }).asJava))(_.sessionAttributes).optionallyWith(requestAttributes.map(value => value.map({
      case (key, value) =>
        (key: java.lang.String) -> (value: java.lang.String)
    }).asJava))(_.requestAttributes).inputText(inputText: java.lang.String).optionallyWith(activeContexts.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.activeContexts).build()
  }
  def asReadOnly: PostTextRequest.ReadOnly = PostTextRequest.wrap(buildAwsValue())
}
object PostTextRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lexruntime.model.PostTextRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: PostTextRequest = PostTextRequest(botNameValue, botAliasValue, userIdValue, sessionAttributesValue.map(value => value), requestAttributesValue.map(value => value), inputTextValue, activeContextsValue.map(value => value.map { item => 
      item.editable
    }))
    def botNameValue: primitives.BotName
    def botAliasValue: primitives.BotAlias
    def userIdValue: primitives.UserId
    def sessionAttributesValue: scala.Option[Map[String, String]]
    def requestAttributesValue: scala.Option[Map[String, String]]
    def inputTextValue: primitives.Text
    def activeContextsValue: scala.Option[List[ActiveContext.ReadOnly]]
    def botName: ZIO[Any, Nothing, primitives.BotName] = ZIO.succeed(botNameValue)
    def botAlias: ZIO[Any, Nothing, primitives.BotAlias] = ZIO.succeed(botAliasValue)
    def userId: ZIO[Any, Nothing, primitives.UserId] = ZIO.succeed(userIdValue)
    def sessionAttributes: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Map[String, String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sessionAttributes", sessionAttributesValue)
    def requestAttributes: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Map[String, String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("requestAttributes", requestAttributesValue)
    def inputText: ZIO[Any, Nothing, primitives.Text] = ZIO.succeed(inputTextValue)
    def activeContexts: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[ActiveContext.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("activeContexts", activeContextsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lexruntime.model.PostTextRequest) extends PostTextRequest.ReadOnly {
    override def botNameValue: primitives.BotName = impl.botName(): primitives.BotName
    override def botAliasValue: primitives.BotAlias = impl.botAlias(): primitives.BotAlias
    override def userIdValue: primitives.UserId = impl.userId(): primitives.UserId
    override def sessionAttributesValue: scala.Option[Map[String, String]] = scala.Option(impl.sessionAttributes()).map(value => value.asScala.map({
      case (key, value) =>
        (key: String) -> (value: String)
    }).toMap)
    override def requestAttributesValue: scala.Option[Map[String, String]] = scala.Option(impl.requestAttributes()).map(value => value.asScala.map({
      case (key, value) =>
        (key: String) -> (value: String)
    }).toMap)
    override def inputTextValue: primitives.Text = impl.inputText(): primitives.Text
    override def activeContextsValue: scala.Option[List[ActiveContext.ReadOnly]] = scala.Option(impl.activeContexts()).map(value => value.asScala.map { item => 
      ActiveContext.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.lexruntime.model.PostTextRequest): ReadOnly = new Wrapper(impl)
}