package io.github.vigoo.zioaws
import io.github.vigoo.zioaws.core.*
import io.github.vigoo.zioaws.core.aspects.*
import io.github.vigoo.zioaws.core.config.AwsConfig
import io.github.vigoo.zioaws.core.httpclient.ServiceHttpCapabilities
import software.amazon.awssdk.core.client.config.{ ClientAsyncConfiguration, SdkAdvancedAsyncClientOption }
import software.amazon.awssdk.services.lexruntime.{ LexRuntimeAsyncClient, LexRuntimeAsyncClientBuilder }
import zio.{ Chunk, Has, IO, URLayer, ZIO, ZLayer, ZManaged }
import zio.stream.ZStream
import org.reactivestreams.Publisher
import scala.jdk.CollectionConverters.*
package object lexruntime {
  type LexRuntime = Has[LexRuntime.Service]
  object LexRuntime {
    trait Service extends AspectSupport[Service] {
      val api: LexRuntimeAsyncClient
      def deleteSession(request: model.DeleteSessionRequest): IO[AwsError, model.DeleteSessionResponse.ReadOnly]
      def postText(request: model.PostTextRequest): IO[AwsError, model.PostTextResponse.ReadOnly]
      def postContent(request: model.PostContentRequest, body: zio.stream.ZStream[Any, AwsError, Byte]): IO[AwsError, StreamingOutputResult[Any, model.PostContentResponse.ReadOnly, Byte]]
      def putSession(request: model.PutSessionRequest): IO[AwsError, StreamingOutputResult[Any, model.PutSessionResponse.ReadOnly, Byte]]
      def getSession(request: model.GetSessionRequest): IO[AwsError, model.GetSessionResponse.ReadOnly]
    }
    object LexRuntimeMock extends zio.test.mock.Mock[LexRuntime] {
      object DeleteSession extends Effect[model.DeleteSessionRequest, AwsError, model.DeleteSessionResponse.ReadOnly]
      object PostText extends Effect[model.PostTextRequest, AwsError, model.PostTextResponse.ReadOnly]
      object PostContent extends Effect[(model.PostContentRequest, zio.stream.ZStream[Any, AwsError, Byte]), AwsError, StreamingOutputResult[Any, model.PostContentResponse.ReadOnly, Byte]]
      object PutSession extends Effect[model.PutSessionRequest, AwsError, StreamingOutputResult[Any, model.PutSessionResponse.ReadOnly, Byte]]
      object GetSession extends Effect[model.GetSessionRequest, AwsError, model.GetSessionResponse.ReadOnly]
      val compose: URLayer[Has[zio.test.mock.Proxy], LexRuntime] = ZLayer.fromServiceM {
        proxy => withRuntime.map {
          rts => new LexRuntime.Service {
            val api: LexRuntimeAsyncClient = null
            def withAspect[R1](newAspect: AwsCallAspect[R1], r: R1): LexRuntime.Service = this
            def deleteSession(request: model.DeleteSessionRequest): IO[AwsError, model.DeleteSessionResponse.ReadOnly] = proxy(DeleteSession, request)
            def postText(request: model.PostTextRequest): IO[AwsError, model.PostTextResponse.ReadOnly] = proxy(PostText, request)
            def postContent(request: model.PostContentRequest, body: zio.stream.ZStream[Any, AwsError, Byte]): IO[AwsError, StreamingOutputResult[Any, model.PostContentResponse.ReadOnly, Byte]] = proxy(PostContent, request, body)
            def putSession(request: model.PutSessionRequest): IO[AwsError, StreamingOutputResult[Any, model.PutSessionResponse.ReadOnly, Byte]] = proxy(PutSession, request)
            def getSession(request: model.GetSessionRequest): IO[AwsError, model.GetSessionResponse.ReadOnly] = proxy(GetSession, request)
          }
        }
      }
    }
  }
  val live: ZLayer[AwsConfig, Throwable, LexRuntime] = customized(identity)
  def customized(customization: LexRuntimeAsyncClientBuilder => LexRuntimeAsyncClientBuilder): ZLayer[AwsConfig, Throwable, LexRuntime] = managed(customization).toLayer
  def managed(customization: LexRuntimeAsyncClientBuilder => LexRuntimeAsyncClientBuilder): ZManaged[AwsConfig, Throwable, LexRuntime.Service] = for (awsConfig <- ZManaged.service[AwsConfig.Service]; executor <- ZIO.executor.toManaged_; builder = LexRuntimeAsyncClient.builder().asyncConfiguration(ClientAsyncConfiguration.builder().advancedOption(SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR, executor.asJava).build()); b0 <- awsConfig.configure[LexRuntimeAsyncClient, LexRuntimeAsyncClientBuilder](builder).toManaged_; b1 <- awsConfig.configureHttpClient[LexRuntimeAsyncClient, LexRuntimeAsyncClientBuilder](b0, ServiceHttpCapabilities(supportsHttp2 = false)).toManaged_; client <- ZIO(customization(b1).build()).toManaged_) yield new LexRuntimeImpl(client, AwsCallAspect.identity, ().asInstanceOf[Any])
  private class LexRuntimeImpl[R](override val api: LexRuntimeAsyncClient, override val aspect: AwsCallAspect[R], r: R) extends LexRuntime.Service with AwsServiceBase[R, LexRuntimeImpl] {
    override val serviceName: String = "LexRuntime"
    override def withAspect[R1](newAspect: AwsCallAspect[R1], r: R1): LexRuntimeImpl[R1] = new LexRuntimeImpl(api, newAspect, r)
    def deleteSession(request: model.DeleteSessionRequest): IO[AwsError, model.DeleteSessionResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lexruntime.model.DeleteSessionRequest, software.amazon.awssdk.services.lexruntime.model.DeleteSessionResponse]("deleteSession", api.deleteSession)(request.buildAwsValue()).map(model.DeleteSessionResponse.wrap).provide(r)
    def postText(request: model.PostTextRequest): IO[AwsError, model.PostTextResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lexruntime.model.PostTextRequest, software.amazon.awssdk.services.lexruntime.model.PostTextResponse]("postText", api.postText)(request.buildAwsValue()).map(model.PostTextResponse.wrap).provide(r)
    def postContent(request: model.PostContentRequest, body: zio.stream.ZStream[Any, AwsError, Byte]): IO[AwsError, StreamingOutputResult[Any, model.PostContentResponse.ReadOnly, Byte]] = asyncRequestInputOutputStream[software.amazon.awssdk.services.lexruntime.model.PostContentRequest, software.amazon.awssdk.services.lexruntime.model.PostContentResponse]("postContent", api.postContent[zio.Task[StreamingOutputResult[R, software.amazon.awssdk.services.lexruntime.model.PostContentResponse, Byte]]])(request.buildAwsValue(), body).map(_.mapResponse(model.PostContentResponse.wrap).provide(r)).provide(r)
    def putSession(request: model.PutSessionRequest): IO[AwsError, StreamingOutputResult[Any, model.PutSessionResponse.ReadOnly, Byte]] = asyncRequestOutputStream[software.amazon.awssdk.services.lexruntime.model.PutSessionRequest, software.amazon.awssdk.services.lexruntime.model.PutSessionResponse]("putSession", api.putSession[zio.Task[StreamingOutputResult[R, software.amazon.awssdk.services.lexruntime.model.PutSessionResponse, Byte]]])(request.buildAwsValue()).map(_.mapResponse(model.PutSessionResponse.wrap).provide(r)).provide(r)
    def getSession(request: model.GetSessionRequest): IO[AwsError, model.GetSessionResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lexruntime.model.GetSessionRequest, software.amazon.awssdk.services.lexruntime.model.GetSessionResponse]("getSession", api.getSession)(request.buildAwsValue()).map(model.GetSessionResponse.wrap).provide(r)
  }
  def deleteSession(request: model.DeleteSessionRequest): ZIO[LexRuntime, AwsError, model.DeleteSessionResponse.ReadOnly] = ZIO.accessM(_.get.deleteSession(request))
  def postText(request: model.PostTextRequest): ZIO[LexRuntime, AwsError, model.PostTextResponse.ReadOnly] = ZIO.accessM(_.get.postText(request))
  def postContent(request: model.PostContentRequest, body: zio.stream.ZStream[Any, AwsError, Byte]): ZIO[LexRuntime, AwsError, StreamingOutputResult[Any, model.PostContentResponse.ReadOnly, Byte]] = ZIO.accessM(_.get.postContent(request, body))
  def putSession(request: model.PutSessionRequest): ZIO[LexRuntime, AwsError, StreamingOutputResult[Any, model.PutSessionResponse.ReadOnly, Byte]] = ZIO.accessM(_.get.putSession(request))
  def getSession(request: model.GetSessionRequest): ZIO[LexRuntime, AwsError, model.GetSessionResponse.ReadOnly] = ZIO.accessM(_.get.getSession(request))
}