package io.github.vigoo.zioaws.lexruntime.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DeleteSessionResponse(botName: scala.Option[primitives.BotName] = None, botAlias: scala.Option[primitives.BotAlias] = None, userId: scala.Option[primitives.UserId] = None, sessionId: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lexruntime.model.DeleteSessionResponse = {
    import DeleteSessionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntime.model.DeleteSessionResponse.builder().optionallyWith(botName.map(value => value: java.lang.String))(_.botName).optionallyWith(botAlias.map(value => value: java.lang.String))(_.botAlias).optionallyWith(userId.map(value => value: java.lang.String))(_.userId).optionallyWith(sessionId.map(value => value: java.lang.String))(_.sessionId).build()
  }
  def asReadOnly: DeleteSessionResponse.ReadOnly = DeleteSessionResponse.wrap(buildAwsValue())
}
object DeleteSessionResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lexruntime.model.DeleteSessionResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DeleteSessionResponse = DeleteSessionResponse(botNameValue.map(value => value), botAliasValue.map(value => value), userIdValue.map(value => value), sessionIdValue.map(value => value))
    def botNameValue: scala.Option[primitives.BotName]
    def botAliasValue: scala.Option[primitives.BotAlias]
    def userIdValue: scala.Option[primitives.UserId]
    def sessionIdValue: scala.Option[String]
    def botName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BotName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("botName", botNameValue)
    def botAlias: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BotAlias] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("botAlias", botAliasValue)
    def userId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.UserId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("userId", userIdValue)
    def sessionId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sessionId", sessionIdValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lexruntime.model.DeleteSessionResponse) extends DeleteSessionResponse.ReadOnly {
    override def botNameValue: scala.Option[primitives.BotName] = scala.Option(impl.botName()).map(value => value: primitives.BotName)
    override def botAliasValue: scala.Option[primitives.BotAlias] = scala.Option(impl.botAlias()).map(value => value: primitives.BotAlias)
    override def userIdValue: scala.Option[primitives.UserId] = scala.Option(impl.userId()).map(value => value: primitives.UserId)
    override def sessionIdValue: scala.Option[String] = scala.Option(impl.sessionId()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.lexruntime.model.DeleteSessionResponse): ReadOnly = new Wrapper(impl)
}