package io.github.vigoo.zioaws.lexruntime.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class PostTextResponse(intentName: scala.Option[primitives.IntentName] = None, nluIntentConfidence: scala.Option[IntentConfidence] = None, alternativeIntents: scala.Option[Iterable[PredictedIntent]] = None, slots: scala.Option[Map[String, String]] = None, sessionAttributes: scala.Option[Map[String, String]] = None, message: scala.Option[primitives.Text] = None, sentimentResponse: scala.Option[SentimentResponse] = None, messageFormat: scala.Option[MessageFormatType] = None, dialogState: scala.Option[DialogState] = None, slotToElicit: scala.Option[String] = None, responseCard: scala.Option[ResponseCard] = None, sessionId: scala.Option[String] = None, botVersion: scala.Option[primitives.BotVersion] = None, activeContexts: scala.Option[Iterable[ActiveContext]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lexruntime.model.PostTextResponse = {
    import PostTextResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntime.model.PostTextResponse.builder().optionallyWith(intentName.map(value => value: java.lang.String))(_.intentName).optionallyWith(nluIntentConfidence.map(value => value.buildAwsValue()))(_.nluIntentConfidence).optionallyWith(alternativeIntents.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.alternativeIntents).optionallyWith(slots.map(value => value.map({
      case (key, value) =>
        (key: java.lang.String) -> (value: java.lang.String)
    }).asJava))(_.slots).optionallyWith(sessionAttributes.map(value => value.map({
      case (key, value) =>
        (key: java.lang.String) -> (value: java.lang.String)
    }).asJava))(_.sessionAttributes).optionallyWith(message.map(value => value: java.lang.String))(_.message).optionallyWith(sentimentResponse.map(value => value.buildAwsValue()))(_.sentimentResponse).optionallyWith(messageFormat.map(value => value.unwrap))(_.messageFormat).optionallyWith(dialogState.map(value => value.unwrap))(_.dialogState).optionallyWith(slotToElicit.map(value => value: java.lang.String))(_.slotToElicit).optionallyWith(responseCard.map(value => value.buildAwsValue()))(_.responseCard).optionallyWith(sessionId.map(value => value: java.lang.String))(_.sessionId).optionallyWith(botVersion.map(value => value: java.lang.String))(_.botVersion).optionallyWith(activeContexts.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.activeContexts).build()
  }
  def asReadOnly: PostTextResponse.ReadOnly = PostTextResponse.wrap(buildAwsValue())
}
object PostTextResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lexruntime.model.PostTextResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: PostTextResponse = PostTextResponse(intentNameValue.map(value => value), nluIntentConfidenceValue.map(value => value.editable), alternativeIntentsValue.map(value => value.map { item => 
      item.editable
    }), slotsValue.map(value => value), sessionAttributesValue.map(value => value), messageValue.map(value => value), sentimentResponseValue.map(value => value.editable), messageFormatValue.map(value => value), dialogStateValue.map(value => value), slotToElicitValue.map(value => value), responseCardValue.map(value => value.editable), sessionIdValue.map(value => value), botVersionValue.map(value => value), activeContextsValue.map(value => value.map { item => 
      item.editable
    }))
    def intentNameValue: scala.Option[primitives.IntentName]
    def nluIntentConfidenceValue: scala.Option[IntentConfidence.ReadOnly]
    def alternativeIntentsValue: scala.Option[List[PredictedIntent.ReadOnly]]
    def slotsValue: scala.Option[Map[String, String]]
    def sessionAttributesValue: scala.Option[Map[String, String]]
    def messageValue: scala.Option[primitives.Text]
    def sentimentResponseValue: scala.Option[SentimentResponse.ReadOnly]
    def messageFormatValue: scala.Option[MessageFormatType]
    def dialogStateValue: scala.Option[DialogState]
    def slotToElicitValue: scala.Option[String]
    def responseCardValue: scala.Option[ResponseCard.ReadOnly]
    def sessionIdValue: scala.Option[String]
    def botVersionValue: scala.Option[primitives.BotVersion]
    def activeContextsValue: scala.Option[List[ActiveContext.ReadOnly]]
    def intentName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntentName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("intentName", intentNameValue)
    def nluIntentConfidence: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, IntentConfidence.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nluIntentConfidence", nluIntentConfidenceValue)
    def alternativeIntents: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[PredictedIntent.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("alternativeIntents", alternativeIntentsValue)
    def slots: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Map[String, String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("slots", slotsValue)
    def sessionAttributes: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Map[String, String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sessionAttributes", sessionAttributesValue)
    def message: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Text] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("message", messageValue)
    def sentimentResponse: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, SentimentResponse.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sentimentResponse", sentimentResponseValue)
    def messageFormat: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, MessageFormatType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("messageFormat", messageFormatValue)
    def dialogState: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DialogState] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dialogState", dialogStateValue)
    def slotToElicit: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("slotToElicit", slotToElicitValue)
    def responseCard: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ResponseCard.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("responseCard", responseCardValue)
    def sessionId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sessionId", sessionIdValue)
    def botVersion: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BotVersion] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("botVersion", botVersionValue)
    def activeContexts: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[ActiveContext.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("activeContexts", activeContextsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lexruntime.model.PostTextResponse) extends PostTextResponse.ReadOnly {
    override def intentNameValue: scala.Option[primitives.IntentName] = scala.Option(impl.intentName()).map(value => value: primitives.IntentName)
    override def nluIntentConfidenceValue: scala.Option[IntentConfidence.ReadOnly] = scala.Option(impl.nluIntentConfidence()).map(value => IntentConfidence.wrap(value))
    override def alternativeIntentsValue: scala.Option[List[PredictedIntent.ReadOnly]] = scala.Option(impl.alternativeIntents()).map(value => value.asScala.map { item => 
      PredictedIntent.wrap(item)
    }.toList)
    override def slotsValue: scala.Option[Map[String, String]] = scala.Option(impl.slots()).map(value => value.asScala.map({
      case (key, value) =>
        (key: String) -> (value: String)
    }).toMap)
    override def sessionAttributesValue: scala.Option[Map[String, String]] = scala.Option(impl.sessionAttributes()).map(value => value.asScala.map({
      case (key, value) =>
        (key: String) -> (value: String)
    }).toMap)
    override def messageValue: scala.Option[primitives.Text] = scala.Option(impl.message()).map(value => value: primitives.Text)
    override def sentimentResponseValue: scala.Option[SentimentResponse.ReadOnly] = scala.Option(impl.sentimentResponse()).map(value => SentimentResponse.wrap(value))
    override def messageFormatValue: scala.Option[MessageFormatType] = scala.Option(impl.messageFormat()).map(value => MessageFormatType.wrap(value))
    override def dialogStateValue: scala.Option[DialogState] = scala.Option(impl.dialogState()).map(value => DialogState.wrap(value))
    override def slotToElicitValue: scala.Option[String] = scala.Option(impl.slotToElicit()).map(value => value: String)
    override def responseCardValue: scala.Option[ResponseCard.ReadOnly] = scala.Option(impl.responseCard()).map(value => ResponseCard.wrap(value))
    override def sessionIdValue: scala.Option[String] = scala.Option(impl.sessionId()).map(value => value: String)
    override def botVersionValue: scala.Option[primitives.BotVersion] = scala.Option(impl.botVersion()).map(value => value: primitives.BotVersion)
    override def activeContextsValue: scala.Option[List[ActiveContext.ReadOnly]] = scala.Option(impl.activeContexts()).map(value => value.asScala.map { item => 
      ActiveContext.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.lexruntime.model.PostTextResponse): ReadOnly = new Wrapper(impl)
}