package io.github.vigoo.zioaws.lexruntime.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class SentimentResponse(sentimentLabel: scala.Option[primitives.SentimentLabel] = None, sentimentScore: scala.Option[primitives.SentimentScore] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lexruntime.model.SentimentResponse = {
    import SentimentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntime.model.SentimentResponse.builder().optionallyWith(sentimentLabel.map(value => value: java.lang.String))(_.sentimentLabel).optionallyWith(sentimentScore.map(value => value: java.lang.String))(_.sentimentScore).build()
  }
  def asReadOnly: SentimentResponse.ReadOnly = SentimentResponse.wrap(buildAwsValue())
}
object SentimentResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lexruntime.model.SentimentResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: SentimentResponse = SentimentResponse(sentimentLabelValue.map(value => value), sentimentScoreValue.map(value => value))
    def sentimentLabelValue: scala.Option[primitives.SentimentLabel]
    def sentimentScoreValue: scala.Option[primitives.SentimentScore]
    def sentimentLabel: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.SentimentLabel] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sentimentLabel", sentimentLabelValue)
    def sentimentScore: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.SentimentScore] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sentimentScore", sentimentScoreValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lexruntime.model.SentimentResponse) extends SentimentResponse.ReadOnly {
    override def sentimentLabelValue: scala.Option[primitives.SentimentLabel] = scala.Option(impl.sentimentLabel()).map(value => value: primitives.SentimentLabel)
    override def sentimentScoreValue: scala.Option[primitives.SentimentScore] = scala.Option(impl.sentimentScore()).map(value => value: primitives.SentimentScore)
  }
  def wrap(impl: software.amazon.awssdk.services.lexruntime.model.SentimentResponse): ReadOnly = new Wrapper(impl)
}