package io.github.vigoo.zioaws.lexruntime.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GenericAttachment(title: scala.Option[primitives.StringWithLength] = None, subTitle: scala.Option[primitives.StringWithLength] = None, attachmentLinkUrl: scala.Option[primitives.StringUrlWithLength] = None, imageUrl: scala.Option[primitives.StringUrlWithLength] = None, buttons: scala.Option[Iterable[Button]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lexruntime.model.GenericAttachment = {
    import GenericAttachment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntime.model.GenericAttachment.builder().optionallyWith(title.map(value => value: java.lang.String))(_.title).optionallyWith(subTitle.map(value => value: java.lang.String))(_.subTitle).optionallyWith(attachmentLinkUrl.map(value => value: java.lang.String))(_.attachmentLinkUrl).optionallyWith(imageUrl.map(value => value: java.lang.String))(_.imageUrl).optionallyWith(buttons.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.buttons).build()
  }
  def asReadOnly: GenericAttachment.ReadOnly = GenericAttachment.wrap(buildAwsValue())
}
object GenericAttachment {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lexruntime.model.GenericAttachment] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GenericAttachment = GenericAttachment(titleValue.map(value => value), subTitleValue.map(value => value), attachmentLinkUrlValue.map(value => value), imageUrlValue.map(value => value), buttonsValue.map(value => value.map { item => 
      item.editable
    }))
    def titleValue: scala.Option[primitives.StringWithLength]
    def subTitleValue: scala.Option[primitives.StringWithLength]
    def attachmentLinkUrlValue: scala.Option[primitives.StringUrlWithLength]
    def imageUrlValue: scala.Option[primitives.StringUrlWithLength]
    def buttonsValue: scala.Option[List[Button.ReadOnly]]
    def title: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.StringWithLength] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("title", titleValue)
    def subTitle: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.StringWithLength] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("subTitle", subTitleValue)
    def attachmentLinkUrl: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.StringUrlWithLength] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("attachmentLinkUrl", attachmentLinkUrlValue)
    def imageUrl: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.StringUrlWithLength] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("imageUrl", imageUrlValue)
    def buttons: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Button.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("buttons", buttonsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lexruntime.model.GenericAttachment) extends GenericAttachment.ReadOnly {
    override def titleValue: scala.Option[primitives.StringWithLength] = scala.Option(impl.title()).map(value => value: primitives.StringWithLength)
    override def subTitleValue: scala.Option[primitives.StringWithLength] = scala.Option(impl.subTitle()).map(value => value: primitives.StringWithLength)
    override def attachmentLinkUrlValue: scala.Option[primitives.StringUrlWithLength] = scala.Option(impl.attachmentLinkUrl()).map(value => value: primitives.StringUrlWithLength)
    override def imageUrlValue: scala.Option[primitives.StringUrlWithLength] = scala.Option(impl.imageUrl()).map(value => value: primitives.StringUrlWithLength)
    override def buttonsValue: scala.Option[List[Button.ReadOnly]] = scala.Option(impl.buttons()).map(value => value.asScala.map { item => 
      Button.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.lexruntime.model.GenericAttachment): ReadOnly = new Wrapper(impl)
}