package io.github.vigoo.zioaws.lexruntime.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetSessionResponse(recentIntentSummaryView: scala.Option[Iterable[IntentSummary]] = None, sessionAttributes: scala.Option[Map[String, String]] = None, sessionId: scala.Option[String] = None, dialogAction: scala.Option[DialogAction] = None, activeContexts: scala.Option[Iterable[ActiveContext]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lexruntime.model.GetSessionResponse = {
    import GetSessionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntime.model.GetSessionResponse.builder().optionallyWith(recentIntentSummaryView.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.recentIntentSummaryView).optionallyWith(sessionAttributes.map(value => value.map({
      case (key, value) =>
        (key: java.lang.String) -> (value: java.lang.String)
    }).asJava))(_.sessionAttributes).optionallyWith(sessionId.map(value => value: java.lang.String))(_.sessionId).optionallyWith(dialogAction.map(value => value.buildAwsValue()))(_.dialogAction).optionallyWith(activeContexts.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.activeContexts).build()
  }
  def asReadOnly: GetSessionResponse.ReadOnly = GetSessionResponse.wrap(buildAwsValue())
}
object GetSessionResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lexruntime.model.GetSessionResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetSessionResponse = GetSessionResponse(recentIntentSummaryViewValue.map(value => value.map { item => 
      item.editable
    }), sessionAttributesValue.map(value => value), sessionIdValue.map(value => value), dialogActionValue.map(value => value.editable), activeContextsValue.map(value => value.map { item => 
      item.editable
    }))
    def recentIntentSummaryViewValue: scala.Option[List[IntentSummary.ReadOnly]]
    def sessionAttributesValue: scala.Option[Map[String, String]]
    def sessionIdValue: scala.Option[String]
    def dialogActionValue: scala.Option[DialogAction.ReadOnly]
    def activeContextsValue: scala.Option[List[ActiveContext.ReadOnly]]
    def recentIntentSummaryView: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[IntentSummary.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("recentIntentSummaryView", recentIntentSummaryViewValue)
    def sessionAttributes: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Map[String, String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sessionAttributes", sessionAttributesValue)
    def sessionId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sessionId", sessionIdValue)
    def dialogAction: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DialogAction.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dialogAction", dialogActionValue)
    def activeContexts: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[ActiveContext.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("activeContexts", activeContextsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lexruntime.model.GetSessionResponse) extends GetSessionResponse.ReadOnly {
    override def recentIntentSummaryViewValue: scala.Option[List[IntentSummary.ReadOnly]] = scala.Option(impl.recentIntentSummaryView()).map(value => value.asScala.map { item => 
      IntentSummary.wrap(item)
    }.toList)
    override def sessionAttributesValue: scala.Option[Map[String, String]] = scala.Option(impl.sessionAttributes()).map(value => value.asScala.map({
      case (key, value) =>
        (key: String) -> (value: String)
    }).toMap)
    override def sessionIdValue: scala.Option[String] = scala.Option(impl.sessionId()).map(value => value: String)
    override def dialogActionValue: scala.Option[DialogAction.ReadOnly] = scala.Option(impl.dialogAction()).map(value => DialogAction.wrap(value))
    override def activeContextsValue: scala.Option[List[ActiveContext.ReadOnly]] = scala.Option(impl.activeContexts()).map(value => value.asScala.map { item => 
      ActiveContext.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.lexruntime.model.GetSessionResponse): ReadOnly = new Wrapper(impl)
}