package io.github.vigoo.zioaws.lexruntime.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait ContentType { def unwrap: software.amazon.awssdk.services.lexruntime.model.ContentType }
object ContentType {
  def wrap(value: software.amazon.awssdk.services.lexruntime.model.ContentType): ContentType = value match {
    case software.amazon.awssdk.services.lexruntime.model.ContentType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lexruntime.model.ContentType.APPLICATION_VND_AMAZONAWS_CARD_GENERIC =>
      val r = `application/vnd.amazonaws.card.generic`
      r
  }
  case object unknownToSdkVersion extends ContentType { override def unwrap: software.amazon.awssdk.services.lexruntime.model.ContentType = software.amazon.awssdk.services.lexruntime.model.ContentType.UNKNOWN_TO_SDK_VERSION }
  case object `application/vnd.amazonaws.card.generic` extends ContentType { override def unwrap: software.amazon.awssdk.services.lexruntime.model.ContentType = software.amazon.awssdk.services.lexruntime.model.ContentType.APPLICATION_VND_AMAZONAWS_CARD_GENERIC }
}