package io.github.vigoo.zioaws.lexruntime.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait DialogActionType { def unwrap: software.amazon.awssdk.services.lexruntime.model.DialogActionType }
object DialogActionType {
  def wrap(value: software.amazon.awssdk.services.lexruntime.model.DialogActionType): DialogActionType = value match {
    case software.amazon.awssdk.services.lexruntime.model.DialogActionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lexruntime.model.DialogActionType.ELICIT_INTENT =>
      val r = ElicitIntent
      r
    case software.amazon.awssdk.services.lexruntime.model.DialogActionType.CONFIRM_INTENT =>
      val r = ConfirmIntent
      r
    case software.amazon.awssdk.services.lexruntime.model.DialogActionType.ELICIT_SLOT =>
      val r = ElicitSlot
      r
    case software.amazon.awssdk.services.lexruntime.model.DialogActionType.CLOSE =>
      val r = Close
      r
    case software.amazon.awssdk.services.lexruntime.model.DialogActionType.DELEGATE =>
      val r = Delegate
      r
  }
  case object unknownToSdkVersion extends DialogActionType { override def unwrap: software.amazon.awssdk.services.lexruntime.model.DialogActionType = software.amazon.awssdk.services.lexruntime.model.DialogActionType.UNKNOWN_TO_SDK_VERSION }
  case object ElicitIntent extends DialogActionType { override def unwrap: software.amazon.awssdk.services.lexruntime.model.DialogActionType = software.amazon.awssdk.services.lexruntime.model.DialogActionType.ELICIT_INTENT }
  case object ConfirmIntent extends DialogActionType { override def unwrap: software.amazon.awssdk.services.lexruntime.model.DialogActionType = software.amazon.awssdk.services.lexruntime.model.DialogActionType.CONFIRM_INTENT }
  case object ElicitSlot extends DialogActionType { override def unwrap: software.amazon.awssdk.services.lexruntime.model.DialogActionType = software.amazon.awssdk.services.lexruntime.model.DialogActionType.ELICIT_SLOT }
  case object Close extends DialogActionType { override def unwrap: software.amazon.awssdk.services.lexruntime.model.DialogActionType = software.amazon.awssdk.services.lexruntime.model.DialogActionType.CLOSE }
  case object Delegate extends DialogActionType { override def unwrap: software.amazon.awssdk.services.lexruntime.model.DialogActionType = software.amazon.awssdk.services.lexruntime.model.DialogActionType.DELEGATE }
}