package io.github.vigoo.zioaws.lexruntime.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class PredictedIntent(intentName: scala.Option[primitives.IntentName] = None, nluIntentConfidence: scala.Option[IntentConfidence] = None, slots: scala.Option[Map[String, String]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lexruntime.model.PredictedIntent = {
    import PredictedIntent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntime.model.PredictedIntent.builder().optionallyWith(intentName.map(value => value: java.lang.String))(_.intentName).optionallyWith(nluIntentConfidence.map(value => value.buildAwsValue()))(_.nluIntentConfidence).optionallyWith(slots.map(value => value.map({
      case (key, value) =>
        (key: java.lang.String) -> (value: java.lang.String)
    }).asJava))(_.slots).build()
  }
  def asReadOnly: PredictedIntent.ReadOnly = PredictedIntent.wrap(buildAwsValue())
}
object PredictedIntent {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lexruntime.model.PredictedIntent] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: PredictedIntent = PredictedIntent(intentNameValue.map(value => value), nluIntentConfidenceValue.map(value => value.editable), slotsValue.map(value => value))
    def intentNameValue: scala.Option[primitives.IntentName]
    def nluIntentConfidenceValue: scala.Option[IntentConfidence.ReadOnly]
    def slotsValue: scala.Option[Map[String, String]]
    def intentName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntentName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("intentName", intentNameValue)
    def nluIntentConfidence: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, IntentConfidence.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nluIntentConfidence", nluIntentConfidenceValue)
    def slots: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Map[String, String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("slots", slotsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lexruntime.model.PredictedIntent) extends PredictedIntent.ReadOnly {
    override def intentNameValue: scala.Option[primitives.IntentName] = scala.Option(impl.intentName()).map(value => value: primitives.IntentName)
    override def nluIntentConfidenceValue: scala.Option[IntentConfidence.ReadOnly] = scala.Option(impl.nluIntentConfidence()).map(value => IntentConfidence.wrap(value))
    override def slotsValue: scala.Option[Map[String, String]] = scala.Option(impl.slots()).map(value => value.asScala.map({
      case (key, value) =>
        (key: String) -> (value: String)
    }).toMap)
  }
  def wrap(impl: software.amazon.awssdk.services.lexruntime.model.PredictedIntent): ReadOnly = new Wrapper(impl)
}